/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.natsIoDoc;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.impl.Headers;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RequestReplyHeaders {
    public static void main(String[] args) {
        try (Connection nc = Nats.connect("nats://localhost:4222");){
            Dispatcher dService = nc.createDispatcher(msg -> {
                Headers hIncoming = msg.getHeaders();
                Headers hResponse = new Headers();
                for (String keys : hIncoming.keySet()) {
                    hResponse.put(keys, hIncoming.get(keys));
                }
                nc.publish(msg.getReplyTo(), hResponse, null);
            });
            dService.subscribe("header.echo");
            Headers headers1 = new Headers();
            headers1.put("X-Request-ID", "1");
            headers1.put("X-Priority", "high");
            CompletableFuture<Message> responseFuture = nc.request("header.echo", headers1, null);
            try {
                Message m = responseFuture.get(500L, TimeUnit.MILLISECONDS);
                Headers hIncoming = m.getHeaders();
                System.out.println("Response Headers: " + hIncoming);
            }
            catch (CancellationException | ExecutionException | TimeoutException e) {
                System.out.println("1) No Response");
            }
            Headers headers2 = new Headers();
            headers2.put("X-Request-ID", "2");
            headers2.put("X-Priority", "med");
            Message m = nc.request("header.echo", headers2, null, Duration.ofMillis(500L));
            if (m == null) {
                System.out.println("2) No Response");
            } else {
                Headers hIncoming = m.getHeaders();
                System.out.println("Response Headers: " + hIncoming);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

