/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.natsIoDoc;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.Message;
import io.nats.client.Nats;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RequestReplyCalculator {
    public static void main(String[] args) {
        try (Connection nc = Nats.connect("nats://localhost:4222");){
            Message m;
            Dispatcher dCalcAdd = nc.createDispatcher(msg -> {
                try {
                    String[] parts = new String(msg.getData()).split(" ");
                    if (parts.length == 2) {
                        int x = Integer.parseInt(parts[0]);
                        int y = Integer.parseInt(parts[1]);
                        nc.publish(msg.getReplyTo(), ("" + (x + y)).getBytes(StandardCharsets.UTF_8));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            dCalcAdd.subscribe("calc.add");
            CompletableFuture<Message> responseFuture = nc.request("calc.add", "5 3".getBytes(StandardCharsets.UTF_8));
            try {
                m = responseFuture.get(500L, TimeUnit.MILLISECONDS);
                System.out.printf("5 + 3 = %s\n", new String(m.getData()));
            }
            catch (CancellationException | ExecutionException | TimeoutException e) {
                System.out.println("1) No Response");
            }
            m = nc.request("calc.add", "10 7".getBytes(StandardCharsets.UTF_8), Duration.ofMillis(500L));
            if (m == null) {
                System.out.println("2) No Response");
            } else {
                System.out.printf("10 + 7 = %s\n", new String(m.getData()));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

