/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.natsIoDoc;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.Message;
import io.nats.client.Nats;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RequestReplyBasic {
    public static void main(String[] args) {
        try (Connection nc = Nats.connect("nats://localhost:4222");){
            Message m;
            Dispatcher dTime = nc.createDispatcher(msg -> nc.publish(msg.getReplyTo(), ("" + System.currentTimeMillis()).getBytes(StandardCharsets.UTF_8)));
            dTime.subscribe("time");
            CompletableFuture<Message> responseFuture = nc.request("time", null);
            try {
                m = responseFuture.get(500L, TimeUnit.MILLISECONDS);
                System.out.println("1) Time is " + new Date(Long.parseLong(new String(m.getData()))));
            }
            catch (CancellationException | ExecutionException | TimeoutException e) {
                System.out.println("1) No Response");
            }
            m = nc.request("time", null, Duration.ofMillis(500L));
            if (m == null) {
                System.out.println("2) No Response");
            } else {
                System.out.println("2) Time is " + new Date(Long.parseLong(new String(m.getData()))));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

