/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.natsIoDoc;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.Nats;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class QueueGroupsBasic {
    public static void main(String[] args) {
        try (Connection nc = Nats.connect("nats://localhost:4222");){
            AtomicInteger count1 = new AtomicInteger();
            AtomicInteger count2 = new AtomicInteger();
            AtomicInteger count3 = new AtomicInteger();
            Dispatcher worker1 = nc.createDispatcher(msg -> {
                count1.incrementAndGet();
                System.out.println("Asynchronous Subscriber 1 Received: " + new String(msg.getData(), StandardCharsets.UTF_8));
            });
            worker1.subscribe("orders.new", "new-orders-queue");
            Dispatcher worker2 = nc.createDispatcher(msg -> {
                count2.incrementAndGet();
                System.out.println("Asynchronous Subscriber 2 Received: " + new String(msg.getData(), StandardCharsets.UTF_8));
            });
            worker2.subscribe("orders.new", "new-orders-queue");
            Dispatcher worker3 = nc.createDispatcher(msg -> {
                count3.incrementAndGet();
                System.out.println("Asynchronous Subscriber 3 Received: " + new String(msg.getData(), StandardCharsets.UTF_8));
            });
            worker3.subscribe("orders.new", "new-orders-queue");
            try {
                nc.flush(Duration.ofSeconds(1L));
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
            for (int i = 1; i <= 10; ++i) {
                byte[] data = ("Order Number: " + i).getBytes(StandardCharsets.UTF_8);
                nc.publish("orders.new", data);
            }
            System.out.println("Messages published to orders.new");
            Thread.sleep(1000L);
            System.out.println("Asynchronous Subscriber 1 received " + count1.get() + " messages.");
            System.out.println("Asynchronous Subscriber 2 received " + count2.get() + " messages.");
            System.out.println("Asynchronous Subscriber 3 received " + count3.get() + " messages.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

