/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.natsIoDoc;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.Subscription;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;

public class PublishSubscribeBasic {
    public static void main(String[] args) {
        try (Connection nc = Nats.connect("nats://localhost:4222");){
            CountDownLatch latch = new CountDownLatch(1);
            Dispatcher d = nc.createDispatcher(msg -> {
                System.out.println("Asynchronous Subscriber Received: " + new String(msg.getData(), StandardCharsets.UTF_8));
                latch.countDown();
            });
            d.subscribe("events.data");
            Subscription syncSub = nc.subscribe("events.data");
            byte[] data = "xyz123".getBytes(StandardCharsets.UTF_8);
            nc.publish("events.data", data);
            System.out.println("Message published to events.data");
            System.out.println("Waiting for message on events.data");
            latch.await();
            Message m = syncSub.nextMessage(500L);
            System.out.println("Synchronous Subscriber Read: " + new String(m.getData(), StandardCharsets.UTF_8));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

