/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.api.AckPolicy;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.time.Duration;

public class NatsJsPushSubFilterSubject {
    static final String usageString = "\nUsage: java -cp <classpath> io.nats.examples.jetstream.NatsJsPushSubFilterSubject [-s server] [-strm stream] [-sub subject-prefix]\n\nDefault Values:\n   [-strm] fs-stream\n   [-sub]  fs-subject\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Push Subscribe with Filter Subject", args, usageString).defaultStream("fs-stream").defaultSubject("fs-subject").build();
        String subjectWild = exArgs.subject + ".*";
        String subjectA = exArgs.subject + ".A";
        String subjectB = exArgs.subject + ".B";
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server, true));){
            JetStreamManagement jsm = nc.jetStreamManagement();
            NatsJsUtils.createStreamExitWhenExists(jsm, exArgs.stream, subjectWild);
            JetStream js = nc.jetStream();
            NatsJsUtils.publish(js, subjectA, 1);
            NatsJsUtils.publish(js, subjectB, 1);
            NatsJsUtils.publish(js, subjectA, 1);
            NatsJsUtils.publish(js, subjectB, 1);
            ConsumerConfiguration cc = ConsumerConfiguration.builder().ackPolicy(AckPolicy.None).build();
            PushSubscribeOptions pso = ((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().configuration(cc)).build();
            JetStreamSubscription sub = js.subscribe(subjectWild, pso);
            nc.flush(Duration.ofSeconds(5L));
            Message m = sub.nextMessage(Duration.ofSeconds(1L));
            System.out.println("\n1A1. Message should be from '" + subjectA + "', Sequence #1. It was: '" + m.getSubject() + "', Seq #" + m.metaData().streamSequence());
            m = sub.nextMessage(Duration.ofSeconds(1L));
            System.out.println("1B2. Message should be from '" + subjectB + "', Sequence #2. It was: '" + m.getSubject() + "', Seq #" + m.metaData().streamSequence());
            m = sub.nextMessage(Duration.ofSeconds(1L));
            System.out.println("1A3. Message should be from '" + subjectA + "', Sequence #3. It was: '" + m.getSubject() + "', Seq #" + m.metaData().streamSequence());
            m = sub.nextMessage(Duration.ofSeconds(1L));
            System.out.println("1B4. Message should be from '" + subjectB + "', Sequence #4. It was: '" + m.getSubject() + "', Seq #" + m.metaData().streamSequence());
            cc = ConsumerConfiguration.builder().ackPolicy(AckPolicy.None).filterSubject(subjectA).build();
            pso = ((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().configuration(cc)).build();
            sub = js.subscribe(subjectWild, pso);
            nc.flush(Duration.ofSeconds(5L));
            m = sub.nextMessage(Duration.ofSeconds(1L));
            System.out.println("\n2A1. Message should be from '" + subjectA + "', Sequence #1. It was: '" + m.getSubject() + "', Seq #" + m.metaData().streamSequence());
            m = sub.nextMessage(Duration.ofSeconds(1L));
            System.out.println("2A3. Message should be from '" + subjectA + "', Sequence #3. It was: '" + m.getSubject() + "', Seq #" + m.metaData().streamSequence());
            m = sub.nextMessage(Duration.ofSeconds(1L));
            System.out.println("2x. Message should be null: " + m);
            cc = ConsumerConfiguration.builder().ackPolicy(AckPolicy.None).filterSubject(subjectB).build();
            pso = ((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().configuration(cc)).build();
            sub = js.subscribe(subjectWild, pso);
            nc.flush(Duration.ofSeconds(5L));
            m = sub.nextMessage(Duration.ofSeconds(1L));
            System.out.println("\n3A2. Message should be from '" + subjectB + "', Sequence #2. It was: '" + m.getSubject() + "', Seq #" + m.metaData().streamSequence());
            m = sub.nextMessage(Duration.ofSeconds(1L));
            System.out.println("3A4. Message should be from '" + subjectB + "', Sequence #4. It was: '" + m.getSubject() + "', Seq #" + m.metaData().streamSequence());
            m = sub.nextMessage(Duration.ofSeconds(1L));
            System.out.println("3x. Message should be null: " + m);
            System.out.println();
            jsm.deleteStream(exArgs.stream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

