/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.JetStream;
import io.nats.client.MessageHandler;
import io.nats.client.Nats;
import io.nats.client.PushSubscribeOptions;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class NatsJsPushSubBasicAsync {
    static final String usageString = "\nUsage: java -cp <classpath> io.nats.examples.jetstream.NatsJsPushSubBasicAsync [-s server] [-strm stream] [-sub subject] [-mcnt msgCount] [-dur durable]\n\nDefault Values:\n   [-strm]    example-stream\n   [-sub]    example-subject\n   [-mcnt]  10\n\nRun Notes:\n   - durable is optional, durable behaves differently, try it by running this twice with durable set\n   - try msgCount less than or equal to or greater than the number of message you have to see different behavior\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Push Subscribe Basic Async", args, usageString).defaultStream("example-stream").defaultSubject("example-subject").defaultMsgCount(100).build();
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server, true));){
            NatsJsUtils.exitIfStreamNotExists(nc, exArgs.stream);
            Dispatcher dispatcher = nc.createDispatcher();
            JetStream js = nc.jetStream();
            CountDownLatch msgLatch = new CountDownLatch(exArgs.msgCount);
            AtomicInteger received = new AtomicInteger();
            AtomicInteger ignored = new AtomicInteger();
            MessageHandler handler = msg -> {
                if (msgLatch.getCount() == 0L) {
                    ignored.incrementAndGet();
                    System.out.println("Message Ignored, latch count already reached " + new String(msg.getData(), StandardCharsets.UTF_8));
                    msg.nak();
                } else {
                    received.incrementAndGet();
                    System.out.println("\nMessage Received:");
                    if (msg.hasHeaders()) {
                        System.out.println("  Headers:");
                        for (String key : msg.getHeaders().keySet()) {
                            for (String value : msg.getHeaders().get(key)) {
                                System.out.printf("    %s: %s\n", key, value);
                            }
                        }
                    }
                    System.out.printf("  Subject: %s\n  Data: %s\n", msg.getSubject(), new String(msg.getData(), StandardCharsets.UTF_8));
                    System.out.println("  " + msg.metaData());
                    msg.ack();
                    msgLatch.countDown();
                }
            };
            PushSubscribeOptions so = ((PushSubscribeOptions.Builder)((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().stream(exArgs.stream)).durable(exArgs.durable)).build();
            js.subscribe(exArgs.subject, dispatcher, handler, false, so);
            boolean countReachedZero = msgLatch.await(3L, TimeUnit.SECONDS);
            System.out.printf("\nReceived %d messages. Ignored %d messages. Count Reached Zero ? %B.\n", received.get(), ignored.get(), countReachedZero);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

