/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.PullSubscribeOptions;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class NatsJsPullSubIterateUseCases {
    static final String usageString = "\nUsage: java -cp <classpath> io.nats.examples.jetstream.NatsJsPullSubIterateUseCases [-s server] [-strm stream] [-sub subject] [-dur durable]\n\nDefault Values:\n   [-strm] iterate-uc-stream\n   [-sub]  iterate-uc-subject\n   [-dur]  iterate-uc-durable\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Pull Subscription using macro Iterate, Use Cases", args, usageString).defaultStream("iterate-uc-stream").defaultSubject("iterate-uc-subject").defaultDurable("iterate-uc-durable").build();
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server));){
            JetStreamManagement jsm = nc.jetStreamManagement();
            NatsJsUtils.createStreamExitWhenExists(jsm, exArgs.stream, exArgs.subject);
            JetStream js = nc.jetStream();
            ConsumerConfiguration cc = ConsumerConfiguration.builder().ackWait(Duration.ofMillis(2500L)).build();
            PullSubscribeOptions pullOptions = ((PullSubscribeOptions.Builder)((PullSubscribeOptions.Builder)PullSubscribeOptions.builder().durable(exArgs.durable)).configuration(cc)).build();
            System.out.println("\n----------\n0. Initialize the subscription and pull.");
            JetStreamSubscription sub = js.subscribe(exArgs.subject, pullOptions);
            nc.flush(Duration.ofSeconds(1L));
            System.out.println("----------\n1. There are no messages yet");
            Iterator<Message> iterator = sub.iterate(10, Duration.ofSeconds(3L));
            List<Message> messages = NatsJsUtils.reportFetch(iterator);
            messages.forEach(Message::ack);
            System.out.println("We should have received 0 total messages, we received: " + messages.size());
            System.out.println("----------\n2. Publish 10 which satisfies the batch");
            NatsJsUtils.publish(js, exArgs.subject, "A", 10);
            iterator = sub.iterate(10, Duration.ofSeconds(3L));
            messages = NatsJsUtils.reportFetch(iterator);
            messages.forEach(Message::ack);
            System.out.println("We should have received 10 total messages, we received: " + messages.size());
            System.out.println("----------\n3. Publish 20 which is larger than the batch size.");
            NatsJsUtils.publish(js, exArgs.subject, "B", 20);
            iterator = sub.iterate(10, Duration.ofSeconds(3L));
            messages = NatsJsUtils.reportFetch(iterator);
            messages.forEach(Message::ack);
            System.out.println("We should have received 10 total messages, we received: " + messages.size());
            System.out.println("----------\n4. Get the rest of the publish.");
            iterator = sub.iterate(10, Duration.ofSeconds(3L));
            messages = NatsJsUtils.reportFetch(iterator);
            messages.forEach(Message::ack);
            System.out.println("We should have received 10 total messages, we received: " + messages.size());
            System.out.println("----------\n5. Publish 5 which is less than batch size.");
            NatsJsUtils.publish(js, exArgs.subject, "C", 5);
            iterator = sub.iterate(10, Duration.ofSeconds(3L));
            messages = NatsJsUtils.reportFetch(iterator);
            messages.forEach(Message::ack);
            System.out.println("We should have received 5 total messages, we received: " + messages.size());
            System.out.println("----------\n6. Publish 15 which is more than the batch size.");
            NatsJsUtils.publish(js, exArgs.subject, "D", 15);
            iterator = sub.iterate(10, Duration.ofSeconds(3L));
            messages = NatsJsUtils.reportFetch(iterator);
            messages.forEach(Message::ack);
            System.out.println("We should have received 10 total messages, we received: " + messages.size());
            System.out.println("----------\n7. There are 5 messages left.");
            iterator = sub.iterate(10, Duration.ofSeconds(3L));
            messages = NatsJsUtils.reportFetch(iterator);
            messages.forEach(Message::ack);
            System.out.println("We should have received 5 messages, we received: " + messages.size());
            System.out.println("----------\n8. iterate but don't ack.");
            NatsJsUtils.publish(js, exArgs.subject, "E", 10);
            iterator = sub.iterate(10, Duration.ofSeconds(3L));
            messages = NatsJsUtils.reportFetch(iterator);
            System.out.println("We should have received 10 message, we received: " + messages.size());
            ExampleUtils.sleep(3000L);
            System.out.println("----------\n9. iterate, get the messages we did not ack.");
            iterator = sub.iterate(10, Duration.ofSeconds(3L));
            messages = NatsJsUtils.reportFetch(iterator);
            messages.forEach(Message::ack);
            System.out.println("We should have received 10 message, we received: " + messages.size());
            System.out.println("----------\n");
            jsm.deleteStream(exArgs.stream);
        }
        catch (RuntimeException e) {
            System.err.println(e);
        }
        catch (JetStreamApiException | IOException | InterruptedException | TimeoutException e) {
            System.err.println(e);
        }
    }
}

