/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.PullSubscribeOptions;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class NatsJsPullSubExpiresInUseCases {
    static final String usageString = "\nUsage: java -cp <classpath> io.nats.examples.jetstream.NatsJsPullSubExpiresInUseCases [-s server] [-strm stream] [-sub subject] [-dur durable]\n\nDefault Values:\n   [-strm] expires-in-uc-ack-stream\n   [-sub]  expires-in-uc-ack-subject\n   [-dur]  expires-in-uc-ack-durable\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Pull Subscription using primitive Batch With Expire, Use Cases", args, usageString).defaultStream("expires-in-uc-ack-stream").defaultSubject("expires-in-uc-ack-subject").defaultDurable("expires-in-uc-ack-durable").build();
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server));){
            JetStreamManagement jsm = nc.jetStreamManagement();
            NatsJsUtils.createStreamExitWhenExists(jsm, exArgs.stream, exArgs.subject);
            JetStream js = nc.jetStream();
            PullSubscribeOptions pullOptions = ((PullSubscribeOptions.Builder)PullSubscribeOptions.builder().durable(exArgs.durable)).build();
            System.out.println("\n----------\n0. Initialize the subscription and pull.");
            JetStreamSubscription sub = js.subscribe(exArgs.subject, pullOptions);
            nc.flush(Duration.ofSeconds(1L));
            System.out.println("\n----------\n1. Publish some amount of messages, but not entire batch size.");
            NatsJsUtils.publish(js, exArgs.subject, "A", 6);
            sub.pullExpiresIn(10, Duration.ofMillis(1200L));
            List<Message> messages = NatsJsUtils.readMessagesAck(sub, Duration.ofSeconds(2L));
            System.out.println("We should have received 6 total messages, we received: " + messages.size());
            System.out.println("----------\n2. Publish more than the batch size.");
            sub.pullExpiresIn(10, Duration.ofMillis(1200L));
            NatsJsUtils.publish(js, exArgs.subject, "B", 14);
            messages = NatsJsUtils.readMessagesAck(sub, Duration.ofSeconds(2L));
            System.out.println("We should have received 10 total messages, we received: " + messages.size());
            System.out.println("----------\n3. Read without issuing a pull.");
            messages = NatsJsUtils.readMessagesAck(sub, Duration.ofSeconds(2L));
            System.out.println("We should have received 0 total messages, we received: " + messages.size());
            System.out.println("----------\n4. Issue the pull to get the last 4.");
            sub.pullExpiresIn(10, Duration.ofMillis(1200L));
            messages = NatsJsUtils.readMessagesAck(sub, Duration.ofSeconds(2L));
            System.out.println("We should have received 4 total messages, we received: " + messages.size());
            System.out.println("----------\n5. Publish a lot of messages. The last pull was under the batch size.");
            System.out.println("   Issue another pull with batch size less than number of messages.");
            NatsJsUtils.publish(js, exArgs.subject, "C", 25);
            sub.pullExpiresIn(10, Duration.ofMillis(1200L));
            messages = NatsJsUtils.readMessagesAck(sub, Duration.ofSeconds(2L));
            System.out.println("We should have received 10 total messages, we received: " + messages.size());
            System.out.println("----------\n6. Still more messages. Issue another pull with batch size less than number of messages.");
            sub.pullExpiresIn(10, Duration.ofMillis(1200L));
            messages = NatsJsUtils.readMessagesAck(sub, Duration.ofSeconds(2L));
            System.out.println("We should have received 10 total messages, we received: " + messages.size());
            System.out.println("----------\n7. Still more messages. Issue another pull with batch size more than number of messages.");
            sub.pullExpiresIn(10, Duration.ofMillis(1200L));
            messages = NatsJsUtils.readMessagesAck(sub, Duration.ofSeconds(2L));
            System.out.println("We should have received 5 total messages, we received: " + messages.size());
            System.out.println("----------\n8. No messages left.");
            sub.pullExpiresIn(10, Duration.ofMillis(1200L));
            messages = NatsJsUtils.readMessagesAck(sub, Duration.ofSeconds(2L));
            System.out.println("We should have received 0 total messages, we received: " + messages.size());
            System.out.println("----------\n");
            jsm.deleteStream(exArgs.stream);
        }
        catch (RuntimeException e) {
            System.err.println(e);
        }
        catch (JetStreamApiException | IOException | InterruptedException | TimeoutException e) {
            System.err.println(e);
        }
    }
}

