/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.PullSubscribeOptions;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeoutException;

public class NatsJsPullSubBatchSizeUseCases {
    static final String usageString = "\nUsage: java -cp <classpath> io.nats.examples.jetstream.NatsJsPullSubBatchSizeUseCases [-s server] [-strm stream] [-sub subject] [-dur durable]\n\nDefault Values:\n   [-strm] pull-uc-stream\n   [-sub]  pull-uc-subject\n   [-dur]  pull-uc-durable\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Pull Subscription using primitive Batch Size, Use Cases", args, usageString).defaultStream("pull-uc-stream").defaultSubject("pull-uc-subject").defaultDurable("pull-uc-durable").build();
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server));){
            JetStreamManagement jsm = nc.jetStreamManagement();
            NatsJsUtils.createStreamExitWhenExists(jsm, exArgs.stream, exArgs.subject);
            JetStream js = nc.jetStream();
            PullSubscribeOptions pullOptions = ((PullSubscribeOptions.Builder)PullSubscribeOptions.builder().durable(exArgs.durable)).build();
            System.out.println("\n----------\n0. Initialize the subscription and pull.");
            JetStreamSubscription sub = js.subscribe(exArgs.subject, pullOptions);
            nc.flush(Duration.ofSeconds(1L));
            sub.pull(10);
            System.out.println("----------\n1. Publish some amount of messages, but not entire batch size.");
            NatsJsUtils.publish(js, exArgs.subject, "A", 4);
            List<Message> messages = NatsJsUtils.readMessagesAck(sub);
            System.out.println("We should have received 4 total messages, we received: " + messages.size());
            System.out.println("----------\n2. Publish more than the remaining batch size.");
            NatsJsUtils.publish(js, exArgs.subject, "B", 10);
            messages = NatsJsUtils.readMessagesAck(sub);
            System.out.println("We should have received 6 total messages, we received: " + messages.size());
            System.out.println("----------\n3. Read without re-issue.");
            messages = NatsJsUtils.readMessagesAck(sub);
            System.out.println("We should have received 0 total messages, we received: " + messages.size());
            System.out.println("----------\n4. Re-issue to get the last 4.");
            sub.pull(10);
            messages = NatsJsUtils.readMessagesAck(sub);
            System.out.println("We should have received 4 total messages, we received: " + messages.size());
            System.out.println("----------\n");
            jsm.deleteStream(exArgs.stream);
        }
        catch (RuntimeException e) {
            System.err.println(e);
        }
        catch (JetStreamApiException | IOException | InterruptedException | TimeoutException e) {
            System.err.println(e);
        }
    }
}

