/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.PullSubscribeOptions;
import io.nats.client.api.ConsumerInfo;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeoutException;

public class NatsJsPullSubBatchSize {
    static final String usageString = "\nUsage: java -cp <classpath> io.nats.examples.jetstream.NatsJsPullSubBatchSize [-s server] [-strm stream] [-sub subject] [-dur durable] [-mcnt msgCount]\n\nDefault Values:\n   [-strm] pull-stream\n   [-sub]  pull-subject\n   [-dur]  pull-durable\n   [-mcnt] 20\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Pull Subscription using primitive Batch Size", args, usageString).defaultStream("pull-stream").defaultSubject("pull-subject").defaultMsgCount(15).build();
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server));){
            JetStreamManagement jsm = nc.jetStreamManagement();
            NatsJsUtils.createStreamExitWhenExists(jsm, exArgs.stream, exArgs.subject);
            JetStream js = nc.jetStream();
            NatsJsUtils.publishInBackground(js, exArgs.subject, "pull-message", exArgs.msgCount);
            PullSubscribeOptions pullOptions = ((PullSubscribeOptions.Builder)PullSubscribeOptions.builder().durable(exArgs.durable)).build();
            JetStreamSubscription sub = js.subscribe(exArgs.subject, pullOptions);
            nc.flush(Duration.ofSeconds(1L));
            ConsumerInfo ci = sub.getConsumerInfo();
            if (exArgs.durable == null) {
                System.out.println("Server should have assigned an ephemeral consumer name -> " + ci.getName());
            } else {
                System.out.println("Server consumer is named -> " + ci.getName());
            }
            int red = 0;
            while (red < exArgs.msgCount) {
                sub.pull(10);
                Message m = sub.nextMessage(Duration.ofSeconds(1L));
                while (m != null) {
                    if (m.isJetStream()) {
                        System.out.println("" + ++red + ". " + m);
                        m.ack();
                    }
                    m = sub.nextMessage(Duration.ofMillis(100L));
                }
            }
            jsm.deleteStream(exArgs.stream);
        }
        catch (RuntimeException e) {
            System.err.println(e);
        }
        catch (JetStreamApiException | IOException | InterruptedException | TimeoutException e) {
            System.err.println(e);
        }
    }
}

