/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.JetStreamOptions;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamConfiguration;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeoutException;

public class NatsJsPrefix {
    static final String usageString = "\nUsage: java -cp <classpath> io.nats.examples.jetstream.NatsJsPrefix\n\nRun Notes:\n   - this example is not configured for arguments so requires manual change\n   - you will need to create the prefix.conf and run the server as in the comments at the top of the code.\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        String prefix = "tar.api";
        String streamMadeBySrc = "stream-made-by-src";
        String streamMadeByTar = "stream-made-by-tar";
        String subjectMadeBySrc = "sub-made-by.src";
        String subjectMadeByTar = "sub-made-by.tar";
        String serverSrc = "nats://src:spass@localhost:4222";
        String serverTar = "nats://tar:tpass@localhost:4222";
        try (Connection ncSrc = Nats.connect(ExampleUtils.createExampleOptions(serverSrc));
             Connection ncTar = Nats.connect(ExampleUtils.createExampleOptions(serverTar));){
            JetStreamOptions jsoSrc = JetStreamOptions.builder().build();
            JetStreamOptions jsoTar = JetStreamOptions.builder().prefix(prefix).build();
            JetStreamManagement jsmSrc = ncSrc.jetStreamManagement(jsoSrc);
            JetStreamManagement jsmTar = ncTar.jetStreamManagement(jsoTar);
            System.out.println("\n----------\n1S. Add stream from source account.");
            StreamConfiguration scSrc = StreamConfiguration.builder().name(streamMadeBySrc).storageType(StorageType.Memory).subjects(subjectMadeBySrc).build();
            NatsJsUtils.printStreamInfo(jsmSrc.addStream(scSrc));
            System.out.println("----------\n1T. Add stream from target account.");
            StreamConfiguration scTar = StreamConfiguration.builder().name(streamMadeByTar).storageType(StorageType.Memory).subjects(subjectMadeByTar).build();
            NatsJsUtils.printStreamInfo(jsmTar.addStream(scTar));
            System.out.println("----------\n2S. Connect to js from source account.");
            JetStream jsSrc = ncSrc.jetStream(jsoSrc);
            System.out.println("2T. Connect to js from source account.");
            JetStream jsTar = ncTar.jetStream(jsoTar);
            System.out.println("----------\n3 S->S. Publish on source stream from source account.");
            jsSrc.publish(subjectMadeBySrc, "src-to-src".getBytes());
            System.out.println("3 S->T. Publish on source target from source account.");
            jsSrc.publish(subjectMadeByTar, "src-to-tar".getBytes());
            System.out.println("3 T->S. Publish on source stream from target account.");
            jsTar.publish(subjectMadeBySrc, "tar-to-src".getBytes());
            System.out.println("3 T->T. Publish on target stream from target account.");
            jsTar.publish(subjectMadeByTar, "tar-to-tar".getBytes());
            System.out.println("----------\n4 S<-S. Read from " + subjectMadeBySrc + " from source account");
            NatsJsPrefix.readMessages(ncSrc, jsSrc, subjectMadeBySrc);
            System.out.println("4 S<-T. Read from " + subjectMadeByTar + " from source account");
            NatsJsPrefix.readMessages(ncSrc, jsSrc, subjectMadeByTar);
            System.out.println("4 T<-S. Read from " + subjectMadeBySrc + " from target account");
            NatsJsPrefix.readMessages(ncTar, jsTar, subjectMadeBySrc);
            System.out.println("4 T<-T. Read from " + subjectMadeByTar + " from target account");
            NatsJsPrefix.readMessages(ncTar, jsTar, subjectMadeByTar);
            System.out.println("----------\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void readMessages(Connection nc, JetStream js, String subject) throws InterruptedException, IOException, JetStreamApiException, TimeoutException {
        JetStreamSubscription sub = js.subscribe(subject);
        nc.flush(Duration.ofSeconds(1L));
        Message msg = sub.nextMessage(Duration.ofSeconds(1L));
        while (msg != null && msg.isJetStream()) {
            System.out.println("    NatsMessage |" + msg.getSubject() + "|" + new String(msg.getData()));
            msg.ack();
            msg = sub.nextMessage(Duration.ofSeconds(1L));
        }
    }
}

