/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples;

import io.nats.client.Connection;
import io.nats.client.Message;
import io.nats.client.Nats;
import io.nats.client.Subscription;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import java.nio.charset.StandardCharsets;
import java.time.Duration;

public class NatsSub {
    static final String usageString = "\nUsage: java -cp <classpath> io.nats.examples.NatsSub [-s server] <subject> <msgCount>\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleUtils.expectSubjectAndMsgCount(args, usageString);
        System.out.printf("\nTrying to connect to %s, and listen to %s for %d messages.\n\n", exArgs.server, exArgs.subject, exArgs.msgCount);
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server, true));){
            Subscription sub = nc.subscribe(exArgs.subject);
            nc.flush(Duration.ofSeconds(5L));
            for (int i = 0; i < exArgs.msgCount; ++i) {
                Message msg = sub.nextMessage(Duration.ofHours(1L));
                System.out.printf("\nMessage Received [%d]\n", i + 1);
                if (msg.hasHeaders()) {
                    System.out.println("  Headers:");
                    for (String key : msg.getHeaders().keySet()) {
                        for (String value : msg.getHeaders().get(key)) {
                            System.out.printf("    %s: %s\n", key, value);
                        }
                    }
                }
                System.out.printf("  Subject: %s\n  Data: %s\n", msg.getSubject(), new String(msg.getData(), StandardCharsets.UTF_8));
            }
        }
        catch (Exception exp) {
            System.err.println(exp);
        }
    }
}

