/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.NatsSystemClock;
import io.nats.client.Options;
import io.nats.client.impl.MarkerMessage;
import io.nats.client.impl.MessageQueueBase;
import io.nats.client.impl.NatsMessage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class WriterMessageQueue
extends MessageQueueBase {
    protected static final long MIN_PUSH_TIMEOUT_NANOS = Options.MINIMUM_WRITE_QUEUE_PUSH_TIMEOUT.toNanos();
    protected final int maxMessagesInOutgoingQueue;
    protected final boolean discardWhenFull;
    protected final Lock editLock;
    protected final long pushTimeoutNanos;

    WriterMessageQueue(Duration pushTimeout) {
        this(-1, false, pushTimeout);
    }

    WriterMessageQueue(int maxMessagesInOutgoingQueue, boolean discardWhenFull, Duration pushTimeout) {
        super(maxMessagesInOutgoingQueue);
        this.maxMessagesInOutgoingQueue = this.queueCapacity;
        this.discardWhenFull = discardWhenFull;
        this.pushTimeoutNanos = Math.max(MIN_PUSH_TIMEOUT_NANOS, pushTimeout.toNanos());
        this.editLock = new ReentrantLock();
    }

    boolean push(NatsMessage msg) {
        return this.push(msg, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean push(NatsMessage msg, boolean internal) {
        try {
            long startNanos = NatsSystemClock.nanoTime();
            if (!this.editLock.tryLock(this.pushTimeoutNanos, TimeUnit.NANOSECONDS)) throw new IllegalStateException("Output queue is busy " + this.queue.size());
            try {
                if (!internal && this.discardWhenFull) {
                    if (this.queue.offer(msg)) {
                        this.sizeInBytes.getAndAdd(msg.getSizeInBytes());
                        this.length.incrementAndGet();
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                long timeoutNanosLeft = Math.max(MIN_PUSH_TIMEOUT_NANOS, this.pushTimeoutNanos - (NatsSystemClock.nanoTime() - startNanos));
                if (!this.queue.offer(msg, timeoutNanosLeft, TimeUnit.NANOSECONDS)) throw new IllegalStateException("Output queue is full " + this.queue.size());
                this.sizeInBytes.getAndAdd(msg.getSizeInBytes());
                this.length.incrementAndGet();
                boolean bl = true;
                return bl;
            }
            finally {
                this.editLock.unlock();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    void queueMarkerMessage(MarkerMessage msg) {
        this.queue.offer(msg);
    }

    NatsMessage accumulate(long maxBytesToAccumulate, long maxMessagesToAccumulate, Duration timeout) throws InterruptedException {
        NatsMessage peeked;
        if (!this.isRunning()) {
            return null;
        }
        NatsMessage headMessage = this._poll(timeout);
        if (headMessage == null || headMessage instanceof MarkerMessage) {
            return headMessage;
        }
        if (maxBytesToAccumulate < 1L) {
            maxBytesToAccumulate = Long.MAX_VALUE;
        }
        long accumulatedMessages = 1L;
        long accumulatedSize = headMessage.getSizeInBytes();
        NatsMessage cursor = headMessage;
        while (!cursor.flushImmediatelyAfterPublish && accumulatedMessages < maxMessagesToAccumulate && (peeked = (NatsMessage)this.queue.peek()) != null) {
            if (peeked instanceof MarkerMessage) {
                this.queue.poll();
                if (peeked == MarkerMessage.POISON_PILL) break;
                cursor.next = peeked;
                break;
            }
            long size = peeked.getSizeInBytes();
            if (accumulatedSize + size > maxBytesToAccumulate) break;
            this.queue.poll();
            ++accumulatedMessages;
            accumulatedSize += size;
            cursor.next = peeked;
            cursor = peeked;
        }
        this.length.addAndGet(-accumulatedMessages);
        this.sizeInBytes.addAndGet(-accumulatedSize);
        return headMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void filter() {
        if (this.isRunning()) {
            throw new IllegalStateException("Filter is only supported when the queue is paused");
        }
        this.editLock.lock();
        try {
            ArrayList temp = new ArrayList();
            this.queue.drainTo(temp);
            for (NatsMessage cursor : temp) {
                if (cursor.isFilterOnStop()) {
                    this.sizeInBytes.addAndGet(-cursor.getSizeInBytes());
                    this.length.decrementAndGet();
                    continue;
                }
                this.queue.offer(cursor);
            }
        }
        finally {
            this.editLock.unlock();
        }
    }

    void clear() {
        this.editLock.lock();
        try {
            this.queue.clear();
            this.length.set(0L);
            this.sizeInBytes.set(0L);
        }
        finally {
            this.editLock.unlock();
        }
    }
}

