/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.NUID;
import io.nats.client.ObjectStore;
import io.nats.client.ObjectStoreOptions;
import io.nats.client.PurgeOptions;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.MessageInfo;
import io.nats.client.api.ObjectInfo;
import io.nats.client.api.ObjectLink;
import io.nats.client.api.ObjectMeta;
import io.nats.client.api.ObjectStoreStatus;
import io.nats.client.api.ObjectStoreWatchOption;
import io.nats.client.api.ObjectStoreWatcher;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.api.StreamInfo;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsFeatureBase;
import io.nats.client.impl.NatsJetStreamManagement;
import io.nats.client.impl.NatsMessage;
import io.nats.client.impl.NatsObjectStoreWatchSubscription;
import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.Digester;
import io.nats.client.support.NatsJetStreamClientError;
import io.nats.client.support.NatsObjectStoreUtil;
import io.nats.client.support.Validator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NatsObjectStore
extends NatsFeatureBase
implements ObjectStore {
    private final ObjectStoreOptions oso;
    private final String bucketName;
    private final String rawChunkPrefix;
    private final String rawMetaPrefix;

    NatsObjectStore(String bucketName, NatsConnection connection, ObjectStoreOptions oso, NatsJetStreamManagement jsm) throws IOException {
        super(connection, oso, jsm);
        this.oso = oso;
        this.bucketName = Validator.validateBucketName(bucketName, true);
        this.streamName = NatsObjectStoreUtil.toStreamName(bucketName);
        this.rawChunkPrefix = NatsObjectStoreUtil.toChunkPrefix(bucketName);
        this.rawMetaPrefix = NatsObjectStoreUtil.toMetaPrefix(bucketName);
    }

    String rawChunkSubject(String nuid) {
        return this.rawChunkPrefix + nuid;
    }

    String rawMetaSubject(String name) {
        return this.rawMetaPrefix + NatsObjectStoreUtil.encodeForSubject(name);
    }

    String rawAllMetaSubject() {
        return this.rawMetaPrefix + ">";
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    private ObjectInfo publishMeta(ObjectInfo info) throws IOException, JetStreamApiException {
        this.js.publish(NatsMessage.builder().subject(this.rawMetaSubject(info.getObjectName())).headers(NatsObjectStoreUtil.getMetaHeaders()).data(info.serialize()).build());
        return ObjectInfo.builder(info).modified(DateTimeUtils.gmtNow()).build();
    }

    @Override
    public ObjectInfo put(ObjectMeta meta, InputStream inputStream) throws IOException, JetStreamApiException, NoSuchAlgorithmException {
        ObjectInfo newInfo;
        Validator.validateNotNull(meta, "ObjectMeta");
        Validator.validateNotNull(meta.getObjectName(), "ObjectMeta name");
        Validator.validateNotNull(inputStream, "InputStream");
        Validator.validateNotNull(meta.getObjectMetaOptions(), "Meta Options");
        if (meta.getObjectMetaOptions().getLink() != null) {
            throw NatsJetStreamClientError.OsLinkNotAllowOnPut.instance();
        }
        ObjectInfo oldInfo = this.getInfo(meta.getObjectName());
        String nuid = NUID.nextGlobal();
        String chunkSubject = this.rawChunkSubject(nuid);
        int chunkSize = meta.getObjectMetaOptions().getChunkSize();
        if (chunkSize <= 0) {
            chunkSize = 131072;
        }
        try {
            Digester digester = new Digester();
            long totalSize = 0L;
            int chunks = 0;
            byte[] buffer = new byte[chunkSize];
            int red = inputStream.read(buffer);
            while (red != -1) {
                byte[] payload = red == buffer.length ? buffer : Arrays.copyOfRange(buffer, 0, red);
                digester.update(payload);
                this.js.publish(chunkSubject, payload);
                ++chunks;
                totalSize += (long)red;
                red = inputStream.read(buffer);
            }
            newInfo = this.publishMeta(ObjectInfo.builder(this.bucketName, meta).size(totalSize).chunks(chunks).nuid(nuid).chunkSize(chunkSize).digest(digester.getDigestEntry()).build());
        }
        catch (JetStreamApiException | IOException | NoSuchAlgorithmException e) {
            try {
                this.jsm.purgeStream(this.streamName, PurgeOptions.subject(this.rawChunkSubject(nuid)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (oldInfo != null) {
            try {
                this.jsm.purgeStream(this.streamName, PurgeOptions.builder().subject(this.rawChunkSubject(oldInfo.getNuid())).build());
            }
            catch (JetStreamApiException | IOException exception) {
                // empty catch block
            }
        }
        return newInfo;
    }

    @Override
    public ObjectInfo put(String objectName, InputStream inputStream) throws IOException, JetStreamApiException, NoSuchAlgorithmException {
        return this.put(ObjectMeta.objectName(objectName), inputStream);
    }

    @Override
    public ObjectInfo put(String objectName, byte[] input) throws IOException, JetStreamApiException, NoSuchAlgorithmException {
        return this.put(ObjectMeta.objectName(objectName), (InputStream)new ByteArrayInputStream(input));
    }

    @Override
    public ObjectInfo put(File file) throws IOException, JetStreamApiException, NoSuchAlgorithmException {
        return this.put(ObjectMeta.objectName(file.getName()), Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    @Override
    public ObjectInfo get(String objectName, OutputStream out) throws IOException, JetStreamApiException, InterruptedException, NoSuchAlgorithmException {
        ObjectInfo oi = this.getInfo(objectName, false);
        if (oi == null) {
            throw NatsJetStreamClientError.OsObjectNotFound.instance();
        }
        if (oi.isLink()) {
            ObjectLink link = oi.getLink();
            if (link == null || link.isBucketLink()) {
                throw NatsJetStreamClientError.OsGetLinkToBucket.instance();
            }
            if (link.getBucket().equals(this.bucketName)) {
                return this.get(link.getObjectName(), out);
            }
            return this.js.conn.objectStore(link.getBucket(), this.oso).get(link.getObjectName(), out);
        }
        Digester digester = new Digester();
        long totalBytes = 0L;
        long totalChunks = 0L;
        long expectedChunks = oi.getChunks();
        if (oi.getChunks() == 1L) {
            MessageInfo mi = this.jsm.getLastMessage(this.streamName, this.rawChunkSubject(oi.getNuid()));
            byte[] data = mi.getData();
            totalBytes = data == null ? 0L : (long)data.length;
            totalChunks = 1L;
            digester.update(data);
            if (totalBytes > 0L) {
                out.write(data);
            }
        } else {
            JetStreamSubscription sub = this.js.subscribe(this.rawChunkSubject(oi.getNuid()), ((PushSubscribeOptions.Builder)PushSubscribeOptions.builder().stream(this.streamName)).ordered(true).build());
            Message m = sub.nextMessage(this.jsm.getTimeout());
            while (m != null) {
                long pending = m.metaData().pendingCount();
                if (expectedChunks != pending + ++totalChunks) {
                    throw NatsJetStreamClientError.OsGetChunksMismatch.instance();
                }
                byte[] data = m.getData();
                totalBytes += (long)data.length;
                digester.update(data);
                out.write(data);
                if (pending == 0L) break;
                m = sub.nextMessage(this.jsm.getTimeout());
            }
            try {
                sub.unsubscribe();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (totalChunks != oi.getChunks()) {
            throw NatsJetStreamClientError.OsGetChunksMismatch.instance();
        }
        if (totalBytes != oi.getSize()) {
            throw NatsJetStreamClientError.OsGetSizeMismatch.instance();
        }
        String digest = oi.getDigest();
        if (digest == null || !digester.matches(digest)) {
            throw NatsJetStreamClientError.OsGetDigestMismatch.instance();
        }
        out.flush();
        return oi;
    }

    @Override
    public ObjectInfo getInfo(String objectName) throws IOException, JetStreamApiException {
        return this.getInfo(objectName, false);
    }

    @Override
    public ObjectInfo getInfo(String objectName, boolean includingDeleted) throws IOException, JetStreamApiException {
        MessageInfo mi = this._getLast(this.rawMetaSubject(objectName));
        if (mi == null) {
            return null;
        }
        ObjectInfo info = new ObjectInfo(mi);
        return includingDeleted || !info.isDeleted() ? info : null;
    }

    @Override
    public ObjectInfo updateMeta(String objectName, ObjectMeta meta) throws IOException, JetStreamApiException {
        boolean nameChange;
        Validator.validateNotNull(objectName, "object name");
        Validator.validateNotNull(meta, "ObjectMeta");
        Validator.validateNotNull(meta.getObjectName(), "ObjectMeta name");
        ObjectInfo currentInfo = this.getInfo(objectName, true);
        if (currentInfo == null) {
            throw NatsJetStreamClientError.OsObjectNotFound.instance();
        }
        if (currentInfo.isDeleted()) {
            throw NatsJetStreamClientError.OsObjectIsDeleted.instance();
        }
        boolean bl = nameChange = !objectName.equals(meta.getObjectName());
        if (nameChange && this.getInfo(meta.getObjectName(), false) != null) {
            throw NatsJetStreamClientError.OsObjectAlreadyExists.instance();
        }
        currentInfo = this.publishMeta(ObjectInfo.builder(currentInfo).objectName(meta.getObjectName()).description(meta.getDescription()).headers(meta.getHeaders()).build());
        if (nameChange) {
            this.jsm.purgeStream(this.streamName, PurgeOptions.subject(this.rawMetaSubject(objectName)));
        }
        return currentInfo;
    }

    @Override
    public ObjectInfo delete(String objectName) throws IOException, JetStreamApiException {
        ObjectInfo info = this.getInfo(objectName, true);
        if (info == null) {
            throw NatsJetStreamClientError.OsObjectNotFound.instance();
        }
        if (info.isDeleted()) {
            return info;
        }
        ObjectInfo deleted = this.publishMeta(ObjectInfo.builder(info).deleted(true).size(0L).chunks(0L).digest(null).build());
        this.jsm.purgeStream(this.streamName, PurgeOptions.subject(this.rawChunkSubject(info.getNuid())));
        return deleted;
    }

    @Override
    public ObjectInfo addLink(String objectName, ObjectInfo toInfo) throws IOException, JetStreamApiException {
        Validator.validateNotNull(objectName, "object name");
        Validator.validateNotNull(toInfo, "Link-To ObjectInfo");
        Validator.validateNotNull(toInfo.getObjectName(), "Link-To ObjectMeta");
        if (toInfo.isDeleted()) {
            throw NatsJetStreamClientError.OsObjectIsDeleted.instance();
        }
        if (toInfo.isLink()) {
            throw NatsJetStreamClientError.OsCantLinkToLink.instance();
        }
        ObjectInfo info = this.getInfo(objectName, false);
        if (info != null && !info.isLink()) {
            throw NatsJetStreamClientError.OsObjectAlreadyExists.instance();
        }
        return this.publishMeta(ObjectInfo.builder(this.bucketName, objectName).nuid(NUID.nextGlobal()).objectLink(toInfo.getBucket(), toInfo.getObjectName()).build());
    }

    @Override
    public ObjectInfo addBucketLink(String objectName, ObjectStore toStore) throws IOException, JetStreamApiException {
        Validator.validateNotNull(objectName, "object name");
        Validator.validateNotNull(toStore, "Link-To ObjectStore");
        ObjectInfo info = this.getInfo(objectName, false);
        if (info != null && !info.isLink()) {
            throw NatsJetStreamClientError.OsObjectAlreadyExists.instance();
        }
        return this.publishMeta(ObjectInfo.builder(this.bucketName, objectName).nuid(NUID.nextGlobal()).bucketLink(toStore.getBucketName()).build());
    }

    @Override
    public ObjectStoreStatus seal() throws IOException, JetStreamApiException {
        StreamInfo si = this.jsm.getStreamInfo(this.streamName);
        si = this.jsm.updateStream(StreamConfiguration.builder(si.getConfiguration()).seal().build());
        return new ObjectStoreStatus(si);
    }

    @Override
    public List<ObjectInfo> getList() throws IOException, JetStreamApiException, InterruptedException {
        ArrayList<ObjectInfo> list = new ArrayList<ObjectInfo>();
        this.visitSubject(this.rawAllMetaSubject(), DeliverPolicy.LastPerSubject, false, true, (Message m) -> {
            ObjectInfo oi = new ObjectInfo(m);
            if (!oi.isDeleted()) {
                list.add(oi);
            }
        });
        return list;
    }

    @Override
    public NatsObjectStoreWatchSubscription watch(ObjectStoreWatcher watcher, ObjectStoreWatchOption ... watchOptions) throws IOException, JetStreamApiException, InterruptedException {
        return new NatsObjectStoreWatchSubscription(this, watcher, watchOptions);
    }

    @Override
    public ObjectStoreStatus getStatus() throws IOException, JetStreamApiException {
        return new ObjectStoreStatus(this.jsm.getStreamInfo(this.streamName));
    }
}

