/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import org.jspecify.annotations.NonNull;

public class PurgeOptions
implements JsonSerializable {
    protected final String subject;
    protected final long seq;
    protected final long keep;

    private PurgeOptions(String subject, long seq, long keep) {
        this.subject = subject;
        this.seq = seq;
        this.keep = keep;
    }

    @Override
    public @NonNull String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "filter", this.subject);
        JsonUtils.addField(sb, "seq", this.seq);
        JsonUtils.addField(sb, "keep", this.keep);
        return JsonUtils.endJson(sb).toString();
    }

    public String getSubject() {
        return this.subject;
    }

    public long getSequence() {
        return this.seq;
    }

    public long getKeep() {
        return this.keep;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PurgeOptions subject(String subject) {
        return new Builder().subject(subject).build();
    }

    public static class Builder {
        private String subject;
        private long seq = -1L;
        private long keep = -1L;

        public Builder subject(String subject) {
            this.subject = Validator.validateSubjectStrict(subject, false);
            return this;
        }

        public Builder sequence(long seq) {
            this.seq = seq;
            return this;
        }

        public Builder keep(long keep) {
            this.keep = keep;
            return this;
        }

        public PurgeOptions build() {
            if (this.seq > 0L && this.keep > 0L) {
                throw new IllegalArgumentException("seq and keep are mutually exclusive.");
            }
            return new PurgeOptions(this.subject, this.seq, this.keep);
        }
    }
}

