/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.jetstream;

import io.nats.client.Connection;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.Nats;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.api.ConsumerPauseResponse;
import io.nats.client.support.DateTimeUtils;
import io.nats.examples.ExampleArgs;
import io.nats.examples.ExampleUtils;
import io.nats.examples.jetstream.NatsJsUtils;
import java.time.ZonedDateTime;
import java.util.List;

public class NatsJsManageConsumers {
    static final String usageString = "\nUsage: java -cp <classpath> NatsJsManageConsumers [-s server] [-strm stream] [-sub subject] [-dur durable-prefix]\n\nDefault Values:\n   [-strm] mcon-stream\n   [-sub] mcon-subject\n   [-dur] mcon-durable-\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\nSet the environment variable NATS_NKEY to use challenge response authentication by setting a file containing your private key.\n\nSet the environment variable NATS_CREDS to use JWT/NKey authentication by setting a file containing your user creds.\n\nUse the URL in the -s server parameter for user/pass/token authentication.\n";

    public static void main(String[] args) {
        ExampleArgs exArgs = ExampleArgs.builder("Manage Consumers", args, usageString).defaultStream("mcon-stream").defaultSubject("mcon-subject").defaultDurable("mcon-durable-").build();
        String durable1 = exArgs.durable + "1";
        String durable2 = exArgs.durable + "2";
        try (Connection nc = Nats.connect(ExampleUtils.createExampleOptions(exArgs.server));){
            JetStreamManagement jsm = nc.jetStreamManagement();
            NatsJsUtils.createStreamExitWhenExists(jsm, exArgs.stream, exArgs.subject);
            System.out.println("\n----------\n1. Configure And Add Consumers");
            ConsumerConfiguration cc = ConsumerConfiguration.builder().durable(durable1).build();
            ConsumerInfo ci = jsm.addOrUpdateConsumer(exArgs.stream, cc);
            NatsJsUtils.printObject(ci, new String[0]);
            cc = ConsumerConfiguration.builder().durable(durable2).build();
            ci = jsm.addOrUpdateConsumer(exArgs.stream, cc);
            NatsJsUtils.printObject(ci, new String[0]);
            System.out.println("\n----------\n2. getConsumers");
            List<ConsumerInfo> consumers = jsm.getConsumers(exArgs.stream);
            NatsJsUtils.printConsumerInfoList(consumers);
            System.out.println("\n----------\n3. getConsumerNames");
            List<String> consumerNames = jsm.getConsumerNames(exArgs.stream);
            NatsJsUtils.printObject(consumerNames, new String[0]);
            System.out.println("\n----------\n4. pauseConsumer");
            ZonedDateTime pauseUntil = ZonedDateTime.now(DateTimeUtils.ZONE_ID_GMT).plusSeconds(30L);
            ConsumerPauseResponse pauseResponse = jsm.pauseConsumer(exArgs.stream, durable1, pauseUntil);
            NatsJsUtils.printObject(pauseResponse, new String[0]);
            ci = jsm.getConsumerInfo(exArgs.stream, durable1);
            NatsJsUtils.printObject(ci, new String[0]);
            System.out.println("\n----------\n5. resumeConsumer");
            jsm.resumeConsumer(exArgs.stream, durable1);
            ci = jsm.getConsumerInfo(exArgs.stream, durable1);
            NatsJsUtils.printObject(ci, new String[0]);
            System.out.println("\n----------\n6. Delete consumers");
            jsm.deleteConsumer(exArgs.stream, durable1);
            consumerNames = jsm.getConsumerNames(exArgs.stream);
            NatsJsUtils.printObject(consumerNames, new String[0]);
            System.out.println("\n----------\n7. Delete consumer again");
            try {
                jsm.deleteConsumer(exArgs.stream, durable1);
            }
            catch (JetStreamApiException e) {
                System.out.println("Exception was: '" + e.getMessage() + "'");
            }
            System.out.println("\n----------\n8. Pause non-existent consumer .");
            try {
                jsm.pauseConsumer(exArgs.stream, durable1, ZonedDateTime.now());
            }
            catch (JetStreamApiException e) {
                System.out.println("Exception was: '" + e.getMessage() + "'");
            }
            System.out.println("\n----------");
            jsm.deleteStream(exArgs.stream);
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }
}

