/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.chaosTestApp;

import io.nats.client.Connection;
import io.nats.client.Consumer;
import io.nats.client.ErrorListener;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.Subscription;
import io.nats.client.api.ServerInfo;
import io.nats.client.support.Status;
import io.nats.examples.chaosTestApp.Output;

public class OutputErrorListener
implements ErrorListener {
    String id;
    java.util.function.Consumer<String> watcher;

    public OutputErrorListener(String id) {
        this(id, null);
    }

    public OutputErrorListener(String id, java.util.function.Consumer<String> watcher) {
        this.id = id;
        this.watcher = watcher;
    }

    @Override
    public String supplyMessage(String label, Connection conn, Consumer consumer, Subscription sub, Object ... pairs) {
        ServerInfo si;
        StringBuilder sb = new StringBuilder(label);
        if (conn != null && (si = conn.getServerInfo()) != null) {
            sb.append(", CONN: ").append(conn.getServerInfo().getClientId());
        }
        if (consumer != null) {
            sb.append(", CON: ").append(consumer.hashCode());
        }
        if (sub != null) {
            sb.append(", SUB: ").append(sub.hashCode());
            if (sub instanceof JetStreamSubscription) {
                JetStreamSubscription jssub = (JetStreamSubscription)sub;
                sb.append(", CON: ").append(jssub.getConsumerName());
            }
        }
        for (int x = 0; x < pairs.length; ++x) {
            sb.append(", ").append(pairs[x]).append(pairs[++x]);
        }
        if (this.watcher != null) {
            this.watcher.accept(sb.toString());
        }
        return sb.toString();
    }

    @Override
    public void errorOccurred(Connection conn, String error) {
        Output.controlMessage(this.id, this.supplyMessage("SEVERE errorOccurred", conn, null, null, "Error: ", error));
    }

    @Override
    public void exceptionOccurred(Connection conn, Exception exp) {
        Output.controlMessage(this.id, this.supplyMessage("SEVERE exceptionOccurred", conn, null, null, "EX: ", exp));
    }

    @Override
    public void slowConsumerDetected(Connection conn, Consumer consumer) {
        Output.controlMessage(this.id, this.supplyMessage("WARN slowConsumerDetected", conn, consumer, null, new Object[0]));
    }

    @Override
    public void messageDiscarded(Connection conn, Message msg) {
        Output.controlMessage(this.id, this.supplyMessage("INFO messageDiscarded", conn, null, null, "Message: ", msg));
    }

    @Override
    public void heartbeatAlarm(Connection conn, JetStreamSubscription sub, long lastStreamSequence, long lastConsumerSequence) {
        Output.controlMessage(this.id, this.supplyMessage("SEVERE HB Alarm", conn, null, sub, "lastStreamSeq: ", lastStreamSequence, "lastConsumerSeq: ", lastConsumerSequence));
    }

    @Override
    public void unhandledStatus(Connection conn, JetStreamSubscription sub, Status status) {
        Output.controlMessage(this.id, this.supplyMessage("WARN unhandledStatus", conn, null, sub, "Status:", status));
    }

    @Override
    public void pullStatusWarning(Connection conn, JetStreamSubscription sub, Status status) {
    }

    @Override
    public void pullStatusError(Connection conn, JetStreamSubscription sub, Status status) {
        Output.controlMessage(this.id, this.supplyMessage("SEVERE pullStatusError", conn, null, sub, "Status:", status));
    }

    @Override
    public void flowControlProcessed(Connection conn, JetStreamSubscription sub, String id, ErrorListener.FlowControlSource source) {
        Output.controlMessage(this.id, this.supplyMessage("INFO flowControlProcessed", conn, null, sub, new Object[]{"FlowControlSource:", source}));
    }

    @Override
    public void socketWriteTimeout(Connection conn) {
        Output.controlMessage(this.id, this.supplyMessage("SEVERE socketWriteTimeout", conn, null, null, new Object[0]));
    }
}

