/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.chaosTestApp;

import io.nats.client.Connection;
import io.nats.client.JetStreamManagement;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.api.StreamInfo;
import io.nats.examples.chaosTestApp.ConnectableConsumer;
import io.nats.examples.chaosTestApp.Monitor;
import io.nats.examples.chaosTestApp.Output;
import io.nats.examples.chaosTestApp.Publisher;
import io.nats.examples.chaosTestApp.PushConsumer;
import io.nats.examples.chaosTestApp.SimpleConsumer;
import io.nats.examples.chaosTestApp.SimpleFetchConsumer;
import io.nats.examples.chaosTestApp.support.CommandLine;
import io.nats.examples.chaosTestApp.support.CommandLineConsumer;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ChaosTestApp {
    public static final String APP_LABEL = "APP";
    public static String[] MANUAL_ARGS = "--servers nats://localhost:4222 --stream jchaos-stream --subject jchaos-subject --create --publish --pubjitter 30 --simple ordered 100 5000".split(" ");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        args = MANUAL_ARGS;
        CommandLine cmd = new CommandLine(args);
        try {
            Output.start(cmd);
            Output.controlMessage(APP_LABEL, cmd.toString().replace(" --", "    \n--"));
            CountDownLatch waiter = new CountDownLatch(1);
            Publisher publisher = null;
            ArrayList<ConnectableConsumer> cons = null;
            if (cmd.create) {
                Options options = cmd.makeManagmentOptions();
                try (Connection nc = Nats.connect(options);){
                    System.out.println(nc.getServerInfo());
                    JetStreamManagement jsm = nc.jetStreamManagement();
                    ChaosTestApp.createOrReplaceStream(cmd, jsm);
                }
                catch (Exception e) {
                    Output.errorMessage(APP_LABEL, e.getMessage());
                }
            }
            if (!cmd.commandLineConsumers.isEmpty()) {
                cons = new ArrayList<ConnectableConsumer>();
                for (CommandLineConsumer clc : cmd.commandLineConsumers) {
                    ConnectableConsumer con;
                    switch (clc.consumerType) {
                        case Push: {
                            con = new PushConsumer(cmd, clc.consumerKind);
                            break;
                        }
                        case Simple: {
                            con = new SimpleConsumer(cmd, clc.consumerKind, clc.batchSize, clc.expiresIn);
                            break;
                        }
                        case Fetch: {
                            con = new SimpleFetchConsumer(cmd, clc.consumerKind, clc.batchSize, clc.expiresIn);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported consumer type: " + (Object)((Object)clc.consumerType));
                        }
                    }
                    Output.controlMessage(APP_LABEL, con.label);
                    cons.add(con);
                }
            }
            if (cmd.publish) {
                publisher = new Publisher(cmd, cmd.pubjitter);
                Thread pubThread = new Thread(publisher);
                pubThread.start();
            }
            if (publisher == null && cons == null) {
                return;
            }
            Monitor monitor = new Monitor(cmd, publisher, cons);
            Thread monThread = new Thread(monitor);
            monThread.start();
            long runtime = cmd.runtime < 1L ? Long.MAX_VALUE : cmd.runtime;
            waiter.await(runtime, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Output.dumpControl();
            System.exit(0);
        }
    }

    public static void createOrReplaceStream(CommandLine cmd, JetStreamManagement jsm) {
        try {
            jsm.deleteStream(cmd.stream);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            StreamConfiguration sc = StreamConfiguration.builder().name(cmd.stream).storageType(StorageType.File).subjects(cmd.subject).replicas(cmd.r3 ? 3 : 1).build();
            StreamInfo si = jsm.addStream(sc);
            Output.controlMessage(APP_LABEL, "Create Stream\n" + Output.formatted(si.getConfiguration()));
        }
        catch (Exception e) {
            Output.fatalMessage(APP_LABEL, "Failed creating stream: '" + cmd.stream + "' " + e);
            System.exit(-1);
        }
    }
}

