/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.autobench;

import io.nats.client.Options;
import io.nats.examples.autobench.AutoBenchmark;
import io.nats.examples.autobench.JsPubAsyncRoundsBenchmark;
import io.nats.examples.autobench.JsPubBenchmark;
import io.nats.examples.autobench.JsSubBenchmark;
import io.nats.examples.autobench.LatencyBenchmark;
import io.nats.examples.autobench.PubBenchmark;
import io.nats.examples.autobench.PubDispatchBenchmark;
import io.nats.examples.autobench.PubSubBenchmark;
import io.nats.examples.autobench.PubWithHeadersBenchmark;
import io.nats.examples.autobench.ReqReplyBenchmark;
import java.security.Provider;
import java.security.Security;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;

public class NatsAutoBench {
    static final String usageString = "\nUsage: java -cp <classpath> NatsAutoBench\n[serverURL] [help] [tiny|small|med|large] [conscrypt] [jsfile]\n[PubOnly] [PubOnlyWithHeaders] [PubSub] [PubDispatch] [ReqReply] [Latency] \n[JsPubSync] [JsPubAsync] [JsSub] [JsPubRounds][-lcsv <filespec>] \n\nIf no specific test name(s) are supplied all will be run, otherwise only supplied tests will be run.\n\nUse tls:// or opentls:// to require tls, via the Default SSLContext\n\n\ntiny, small and med reduce the number of messages used for tests, which can help on slower machines\n";
    static int[] sizes = new int[]{0, 8, 32, 256, 512, 1024, 4096, 8192};
    static long[] msgsMultiple = new long[]{100L, 100L, 100L, 100L, 100L, 10L, 5L, 1L};
    static int[] msgsDivider = new int[]{5, 5, 10, 10, 10, 10, 10, 10};
    static int[] roundSize = new int[]{10, 100, 200, 500, 1000};

    public static void main(String[] args) {
        args = "small PubOnly".split(" ");
        Arguments a = NatsAutoBench.readArgs(args);
        System.out.printf("Connecting to NATS server at %s\n", a.server);
        try {
            Options.Builder builder = new Options.Builder().server(a.server).connectionTimeout(Duration.ofSeconds(1L)).noReconnect();
            if (a.conscrypt) {
                Provider provider = (Provider)Class.forName("org.conscrypt.OpenSSLProvider").newInstance();
                Security.insertProviderAt(provider, 1);
            }
            if (a.server.startsWith("tls")) {
                System.out.println("Security Provider - " + SSLContext.getDefault().getProvider().getInfo());
            }
            Options connectOptions = builder.build();
            List<AutoBenchmark> tests = NatsAutoBench.buildTestList(a);
            System.out.println("Running warmup");
            NatsAutoBench.runWarmup(connectOptions);
            System.out.printf("Current memory usage is %s / %s / %s free/total/max\n", AutoBenchmark.humanBytes(Runtime.getRuntime().freeMemory()), AutoBenchmark.humanBytes(Runtime.getRuntime().totalMemory()), AutoBenchmark.humanBytes(Runtime.getRuntime().maxMemory()));
            System.out.print("Executing tests ");
            for (AutoBenchmark test : tests) {
                test.execute(connectOptions);
                System.out.print(".");
                System.gc();
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {}
            }
            System.out.println();
            System.out.println();
            Class<?> lastTestClass = null;
            AutoBenchmark lastTest = null;
            for (AutoBenchmark test : tests) {
                if (test.getClass() != lastTestClass) {
                    if (lastTestClass != null) {
                        test.afterPrintLastOfKind();
                        System.out.println();
                    }
                    test.beforePrintFirstOfKind();
                    lastTest = test;
                    lastTestClass = test.getClass();
                }
                test.printResult();
            }
            if (lastTest != null) {
                lastTest.afterPrintLastOfKind();
            }
            System.out.println();
            System.out.printf("Final memory usage is %s / %s / %s free/total/max\n", AutoBenchmark.humanBytes(Runtime.getRuntime().freeMemory()), AutoBenchmark.humanBytes(Runtime.getRuntime().totalMemory()), AutoBenchmark.humanBytes(Runtime.getRuntime().maxMemory()));
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public static void runWarmup(Options connectOptions) throws Exception {
        PubSubBenchmark warmup = new PubSubBenchmark("warmup", 100000L, 64L);
        ((AutoBenchmark)warmup).execute(connectOptions);
        if (warmup.getException() != null) {
            System.out.println("Encountered exception " + warmup.getException().getMessage());
            System.exit(-1);
        }
    }

    public static List<AutoBenchmark> buildTestList(Arguments a) {
        ArrayList<AutoBenchmark> tests = new ArrayList<AutoBenchmark>();
        if (a.allTests || a.pubOnly) {
            NatsAutoBench.addTests(a.baseMsgs, a.maxSize, tests, sizes, msgsMultiple, (msize, mcnt) -> new PubBenchmark("PubOnly " + msize, mcnt, msize));
        }
        if (a.PubOnlyWithHeaders) {
            NatsAutoBench.addTests(a.baseMsgs, a.maxSize, tests, sizes, msgsMultiple, (msize, mcnt) -> new PubWithHeadersBenchmark("PubOnlyWithHeaders " + msize, mcnt, msize));
        }
        if (a.allTests || a.pubSub) {
            NatsAutoBench.addTests(a.baseMsgs, a.maxSize, tests, sizes, msgsMultiple, (msize, mcnt) -> new PubSubBenchmark("PubSub " + msize, mcnt, msize));
        }
        if (a.allTests || a.pubDispatch) {
            NatsAutoBench.addTests(a.baseMsgs, a.maxSize, tests, sizes, msgsMultiple, (msize, mcnt) -> new PubDispatchBenchmark("PubDispatch " + msize, mcnt, msize));
        }
        AtomicBoolean jsPubSyncSaveForJsSub = new AtomicBoolean(false);
        AtomicBoolean jsPubAsyncSaveForJsSub = new AtomicBoolean(a.allTests);
        if (!a.allTests && a.jsSub) {
            if (a.jsPubAsync || !a.jsPubSync) {
                a.jsPubAsync = true;
                jsPubAsyncSaveForJsSub.set(true);
            } else {
                jsPubSyncSaveForJsSub.set(false);
            }
        }
        if (a.allTests || a.jsPubSync) {
            NatsAutoBench.addTests(a.baseMsgs, a.maxSize, tests, sizes, msgsMultiple, (msize, mcnt) -> new JsPubBenchmark("JsPubSync " + msize, mcnt, msize, a.jsFile, true, jsPubSyncSaveForJsSub.get()));
        }
        if (a.allTests || a.jsPubAsync) {
            NatsAutoBench.addTests(a.baseMsgs, a.maxSize, tests, sizes, msgsMultiple, (msize, mcnt) -> new JsPubBenchmark("JsPubAsync " + msize, mcnt, msize, a.jsFile, false, jsPubAsyncSaveForJsSub.get()));
        }
        if (a.allTests || a.jsSub) {
            NatsAutoBench.addTests(a.baseMsgs, a.maxSize, tests, sizes, msgsMultiple, (msize, mcnt) -> new JsSubBenchmark("JsSub " + msize, mcnt, msize));
        }
        if (a.allTests || a.jsPubRounds) {
            NatsAutoBench.addTestsWithRounds(a.baseMsgs, a.maxSize, tests, sizes, msgsMultiple, (msize, mcnt, rsize) -> new JsPubAsyncRoundsBenchmark("JsPubAsyncRounds " + msize + "," + rsize, mcnt, msize, a.jsFile, rsize));
        }
        if (a.allTests || a.reqReply) {
            NatsAutoBench.addRequestReplyTests(a.baseMsgs, a.maxSize, tests, sizes, msgsDivider, (msize, mcnt) -> new ReqReplyBenchmark("ReqReply " + msize, mcnt, msize));
        }
        if (a.allTests || a.latency) {
            NatsAutoBench.addLatencyTests(a.latencyMsgs, a.maxSize, tests, sizes, (msize, mcnt) -> new LatencyBenchmark("Latency " + msize, mcnt, msize, a.lcsv));
        }
        return tests;
    }

    private static void addTests(int baseMsgs, long maxSize, List<AutoBenchmark> tests, int[] sizes, long[] msgsMultiple, AutoBenchmarkConstructor abc) {
        for (int i = 0; i < sizes.length; ++i) {
            int size = sizes[i];
            long msgMult = msgsMultiple[i];
            if ((long)size > maxSize) break;
            tests.add(abc.construct(size, msgMult * (long)baseMsgs));
        }
    }

    private static void addLatencyTests(int latencyMsgs, long maxSize, List<AutoBenchmark> tests, int[] sizes, AutoBenchmarkConstructor abc) {
        for (int size : sizes) {
            if ((long)size > maxSize) break;
            tests.add(abc.construct(size, latencyMsgs));
        }
    }

    private static void addRequestReplyTests(int baseMsgs, long maxSize, List<AutoBenchmark> tests, int[] sizes, int[] msgsDivider, AutoBenchmarkConstructor abc) {
        for (int i = 0; i < sizes.length; ++i) {
            int size = sizes[i];
            int msgDivide = msgsDivider[i];
            if ((long)size > maxSize) break;
            tests.add(abc.construct(size, baseMsgs / msgDivide));
        }
    }

    private static void addTestsWithRounds(int baseMsgs, long maxSize, List<AutoBenchmark> tests, int[] sizes, long[] msgsMultiple, AutoBenchmarkRoundSizeConstructor abrsc) {
        for (int i = 0; i < sizes.length; ++i) {
            int size = sizes[i];
            long msgMult = msgsMultiple[i];
            if ((long)size > maxSize) break;
            for (int rs : roundSize) {
                if ((long)rs > msgMult * (long)baseMsgs) continue;
                tests.add(abrsc.construct(size, msgMult * (long)baseMsgs, rs));
            }
        }
    }

    private static Arguments readArgs(String[] args) {
        Arguments a = new Arguments();
        if (args.length > 0) {
            block42: for (int x = 0; x < args.length; ++x) {
                switch (args[x].toLowerCase()) {
                    case "conscrypt": {
                        a.conscrypt = true;
                        continue block42;
                    }
                    case "large": {
                        a.baseMsgs = 500000;
                        a.latencyMsgs = 25000;
                        continue block42;
                    }
                    case "med": {
                        a.baseMsgs = 50000;
                        a.latencyMsgs = 2500;
                        continue block42;
                    }
                    case "small": {
                        a.baseMsgs = 5000;
                        a.latencyMsgs = 250;
                        a.maxSize = 1024L;
                        continue block42;
                    }
                    case "tiny": {
                        a.baseMsgs = 1000;
                        a.latencyMsgs = 50;
                        a.maxSize = 1024L;
                        continue block42;
                    }
                    case "nano": {
                        a.baseMsgs = 10;
                        a.latencyMsgs = 5;
                        a.maxSize = 512L;
                        continue block42;
                    }
                    case "pubonly": {
                        a.allTests = false;
                        a.pubOnly = true;
                        continue block42;
                    }
                    case "pubonlywithheaders": {
                        a.allTests = false;
                        a.PubOnlyWithHeaders = true;
                        continue block42;
                    }
                    case "pubsub": {
                        a.allTests = false;
                        a.pubSub = true;
                        continue block42;
                    }
                    case "pubdispatch": {
                        a.allTests = false;
                        a.pubDispatch = true;
                        continue block42;
                    }
                    case "reqreply": {
                        a.allTests = false;
                        a.reqReply = true;
                        continue block42;
                    }
                    case "latency": {
                        a.allTests = false;
                        a.latency = true;
                        continue block42;
                    }
                    case "jspubsync": {
                        a.allTests = false;
                        a.jsPubSync = true;
                        continue block42;
                    }
                    case "jspubasync": {
                        a.allTests = false;
                        a.jsPubAsync = true;
                        continue block42;
                    }
                    case "jssub": {
                        a.allTests = false;
                        a.jsSub = true;
                        continue block42;
                    }
                    case "jspubrounds": {
                        a.allTests = false;
                        a.jsPubRounds = true;
                        continue block42;
                    }
                    case "jsfile": {
                        a.jsFile = true;
                        continue block42;
                    }
                    case "-lcsv": {
                        a.lcsv = args[++x];
                        continue block42;
                    }
                    case "help": {
                        System.err.println(usageString);
                        System.exit(-1);
                    }
                    default: {
                        a.server = args[x];
                    }
                }
            }
        }
        return a;
    }

    static class Arguments {
        String server = "nats://localhost:4222";
        boolean conscrypt = false;
        int baseMsgs = 100000;
        int latencyMsgs = 5000;
        long maxSize = 8192L;
        boolean allTests = true;
        boolean pubOnly = false;
        boolean PubOnlyWithHeaders = false;
        boolean pubSub = false;
        boolean pubDispatch = false;
        boolean reqReply = false;
        boolean latency = false;
        boolean jsPubSync = false;
        boolean jsPubAsync = false;
        boolean jsSub = false;
        boolean jsPubRounds = false;
        boolean jsFile = false;
        String lcsv = null;

        Arguments() {
        }
    }

    static interface AutoBenchmarkRoundSizeConstructor {
        public AutoBenchmark construct(long var1, long var3, int var5);
    }

    static interface AutoBenchmarkConstructor {
        public AutoBenchmark construct(long var1, long var3);
    }
}

