/*
 * Decompiled with CFR 0.152.
 */
package io.nats.examples.autobench;

import io.nats.client.Connection;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamManagement;
import io.nats.client.Nats;
import io.nats.client.Options;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamConfiguration;
import io.nats.examples.autobench.AutoBenchmark;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class JsPubBenchmark
extends AutoBenchmark {
    private static final Map<String, String> SAVED_STREAMS = new HashMap<String, String>();
    private static final Map<String, String> SAVED_SUBJECTS = new HashMap<String, String>();
    private final boolean file;
    private final boolean sync;
    private final boolean saveForSub;

    public static String getKey(long messageCount, long messageSize) {
        return "" + messageCount + "x" + messageSize;
    }

    public static String getStream(long messageCount, long messageSize) {
        return SAVED_STREAMS.get(JsPubBenchmark.getKey(messageCount, messageSize));
    }

    public static String getSubject(long messageCount, long messageSize) {
        return SAVED_SUBJECTS.get(JsPubBenchmark.getKey(messageCount, messageSize));
    }

    public JsPubBenchmark(String name, long messageCount, long messageSize, boolean file, boolean sync, boolean saveForSub) {
        super(name, messageCount, messageSize);
        this.file = file;
        this.sync = sync;
        this.saveForSub = saveForSub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Options connectOptions) throws InterruptedException {
        byte[] payload = this.createPayload();
        String subject = this.getSubject();
        String stream = this.getStream();
        if (this.saveForSub) {
            String key = JsPubBenchmark.getKey(this.getMessageCount(), this.getMessageSize());
            SAVED_STREAMS.put(key, stream);
            SAVED_SUBJECTS.put(key, subject);
        }
        try {
            Connection nc = Nats.connect(connectOptions);
            StreamConfiguration sc = StreamConfiguration.builder().name(stream).subjects(subject).storageType(this.file ? StorageType.File : StorageType.Memory).build();
            JetStreamManagement jsm = nc.jetStreamManagement();
            jsm.addStream(sc);
            JetStream js = nc.jetStream();
            try {
                int i;
                this.startTiming();
                if (this.sync) {
                    i = 0;
                    while ((long)i < this.getMessageCount()) {
                        js.publish(subject, payload);
                        ++i;
                    }
                } else {
                    i = 0;
                    while ((long)i < this.getMessageCount()) {
                        js.publishAsync(subject, payload);
                        ++i;
                    }
                }
                this.defaultFlush(nc);
                this.endTiming();
            }
            finally {
                try {
                    if (!this.saveForSub) {
                        jsm.deleteStream(stream);
                    }
                }
                catch (JetStreamApiException | IOException ex) {
                    this.setException(ex);
                }
                finally {
                    nc.close();
                }
            }
        }
        catch (JetStreamApiException | IOException ex) {
            this.setException(ex);
        }
    }
}

