/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Message;
import io.nats.client.SubscribeOptions;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.ConsumerCreateRequest;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.PushMessageManager;
import io.nats.client.support.NatsJetStreamUtil;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class OrderedMessageManager
extends PushMessageManager {
    protected final AtomicLong expectedExternalConsumerSeq = new AtomicLong(1L);
    protected final AtomicReference<String> targetSid = new AtomicReference();

    protected OrderedMessageManager(NatsConnection conn, NatsJetStream js, String stream, SubscribeOptions so, ConsumerConfiguration originalCc, boolean queueMode, boolean syncMode) {
        super(conn, js, stream, so, originalCc, queueMode, syncMode);
    }

    @Override
    protected void startup(NatsJetStreamSubscription sub) {
        this.expectedExternalConsumerSeq.set(1L);
        super.startup(sub);
        this.targetSid.set(sub.getSID());
    }

    @Override
    protected MessageManager.ManageResult manage(Message msg) {
        if (!msg.getSID().equals(this.targetSid.get())) {
            return MessageManager.ManageResult.STATUS_HANDLED;
        }
        if (msg.isJetStream()) {
            long receivedConsumerSeq = msg.metaData().consumerSequence();
            if (this.expectedExternalConsumerSeq.get() != receivedConsumerSeq) {
                this.handleErrorCondition();
                return MessageManager.ManageResult.STATUS_HANDLED;
            }
            this.trackJsMessage(msg);
            this.expectedExternalConsumerSeq.incrementAndGet();
            return MessageManager.ManageResult.MESSAGE;
        }
        return this.manageStatus(msg);
    }

    @Override
    protected void handleHeartbeatError() {
        super.handleHeartbeatError();
        this.handleErrorCondition();
    }

    private void handleErrorCondition() {
        try {
            this.targetSid.set(null);
            this.expectedExternalConsumerSeq.set(1L);
            String newDeliverSubject = this.sub.connection.createInbox();
            this.sub.reSubscribe(newDeliverSubject);
            this.targetSid.set(this.sub.getSID());
            ConsumerConfiguration.Builder b = this.js.consumerConfigurationForOrdered(this.initialCc, this.lastStreamSeq, newDeliverSubject, null);
            if (this.initialCc.getName() != null) {
                b.name(NatsJetStreamUtil.generateConsumerName(this.initialCc.getName()));
            }
            ConsumerConfiguration userCC = b.build();
            ConsumerInfo ci = this.js._createConsumer(this.stream, userCC, ConsumerCreateRequest.Action.Create);
            this.sub.setConsumerName(ci.getName());
            this.startup(this.sub);
        }
        catch (Exception e) {
            try {
                this.js.conn.processException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.initOrResetHeartbeatTimer();
        }
    }
}

