/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.NUID;
import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import io.nats.service.Endpoint;
import io.nats.service.EndpointContext;
import io.nats.service.EndpointStats;
import io.nats.service.InfoResponse;
import io.nats.service.PingResponse;
import io.nats.service.ServiceBuilder;
import io.nats.service.ServiceEndpoint;
import io.nats.service.ServiceMessageHandler;
import io.nats.service.ServiceResponse;
import io.nats.service.StatsResponse;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

public class Service {
    public static final String SRV_PING = "PING";
    public static final String SRV_INFO = "INFO";
    public static final String SRV_STATS = "STATS";
    public static final String DEFAULT_SERVICE_PREFIX = "$SRV.";
    private final Connection conn;
    private final Duration drainTimeout;
    private final ConcurrentHashMap<String, EndpointContext> serviceContexts;
    private final List<EndpointContext> discoveryContexts;
    private final List<Dispatcher> dInternals;
    private final AtomicReference<ZonedDateTime> startTimeRef;
    private final CompletableFuture<Boolean> startedFuture;
    private final PingResponse pingResponse;
    private final InfoResponse infoResponse;
    private final ReentrantLock startStopLock;
    private CompletableFuture<Boolean> runningIndicator;

    Service(ServiceBuilder b) {
        String id = new NUID().next();
        this.conn = b.conn;
        this.drainTimeout = b.drainTimeout;
        this.dInternals = new ArrayList<Dispatcher>();
        this.startStopLock = new ReentrantLock();
        this.startTimeRef = new AtomicReference<ZonedDateTime>(DateTimeUtils.DEFAULT_TIME);
        this.startedFuture = new CompletableFuture();
        this.pingResponse = new PingResponse(id, b.name, b.version, b.metadata);
        this.infoResponse = new InfoResponse(id, b.name, b.version, b.metadata, b.description);
        this.serviceContexts = new ConcurrentHashMap();
        this.addServiceEndpoints(b.serviceEndpoints.values());
        Dispatcher dTemp = null;
        if (b.pingDispatcher == null || b.infoDispatcher == null || b.statsDispatcher == null) {
            dTemp = this.conn.createDispatcher();
            this.dInternals.add(dTemp);
        }
        this.discoveryContexts = new ArrayList<EndpointContext>();
        this.addDiscoveryContexts(SRV_PING, this.pingResponse, b.pingDispatcher, dTemp);
        this.addDiscoveryContexts(SRV_INFO, this.infoResponse, b.infoDispatcher, dTemp);
        this.addStatsContexts(b.statsDispatcher, dTemp);
    }

    public void addServiceEndpoints(ServiceEndpoint ... serviceEndpoints) {
        this.addServiceEndpoints(Arrays.asList(serviceEndpoints));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceEndpoints(Collection<ServiceEndpoint> serviceEndpoints) {
        this.startStopLock.lock();
        try {
            this.infoResponse.addServiceEndpoints(serviceEndpoints);
            for (ServiceEndpoint se : serviceEndpoints) {
                EndpointContext ctx;
                if (se.getDispatcher() == null) {
                    Dispatcher dTemp;
                    Dispatcher dispatcher = dTemp = this.dInternals.isEmpty() ? null : this.dInternals.get(0);
                    if (dTemp == null) {
                        dTemp = this.conn.createDispatcher();
                        this.dInternals.add(dTemp);
                    }
                    ctx = new EndpointContext(this.conn, dTemp, false, se);
                } else {
                    ctx = new EndpointContext(this.conn, null, false, se);
                }
                this.serviceContexts.put(se.getName(), ctx);
                if (this.runningIndicator == null) continue;
                ctx.start();
            }
        }
        finally {
            this.startStopLock.unlock();
        }
    }

    private void addDiscoveryContexts(String discoveryName, Dispatcher dUser, Dispatcher dInternal, ServiceMessageHandler handler) {
        Endpoint[] endpoints;
        for (Endpoint endpoint : endpoints = new Endpoint[]{this.internalEndpoint(discoveryName, null, null), this.internalEndpoint(discoveryName, this.pingResponse.getName(), null), this.internalEndpoint(discoveryName, this.pingResponse.getName(), this.pingResponse.getId())}) {
            this.discoveryContexts.add(new EndpointContext(this.conn, dInternal, true, new ServiceEndpoint(endpoint, handler, dUser)));
        }
    }

    private void addDiscoveryContexts(String discoveryName, ServiceResponse sr, Dispatcher dUser, Dispatcher dInternal) {
        ServiceMessageHandler handler = smsg -> smsg.respond(this.conn, sr.serialize());
        this.addDiscoveryContexts(discoveryName, dUser, dInternal, handler);
    }

    private void addStatsContexts(Dispatcher dUser, Dispatcher dInternal) {
        ServiceMessageHandler handler = smsg -> smsg.respond(this.conn, this.getStatsResponse().serialize());
        this.addDiscoveryContexts(SRV_STATS, dUser, dInternal, handler);
    }

    private Endpoint internalEndpoint(String discoveryName, String optionalServiceNameSegment, String optionalServiceIdSegment) {
        String subject = Service.toDiscoverySubject(discoveryName, optionalServiceNameSegment, optionalServiceIdSegment);
        return new Endpoint(subject, subject, null, null, false);
    }

    static String toDiscoverySubject(String discoveryName, String optionalServiceNameSegment, String optionalServiceIdSegment) {
        if (Validator.nullOrEmpty(optionalServiceIdSegment)) {
            if (Validator.nullOrEmpty(optionalServiceNameSegment)) {
                return DEFAULT_SERVICE_PREFIX + discoveryName;
            }
            return DEFAULT_SERVICE_PREFIX + discoveryName + "." + optionalServiceNameSegment;
        }
        return DEFAULT_SERVICE_PREFIX + discoveryName + "." + optionalServiceNameSegment + "." + optionalServiceIdSegment;
    }

    public CompletableFuture<Boolean> startService() {
        this.startStopLock.lock();
        try {
            if (this.runningIndicator == null) {
                this.runningIndicator = new CompletableFuture();
                for (EndpointContext ctx : this.serviceContexts.values()) {
                    ctx.start();
                }
                for (EndpointContext ctx : this.discoveryContexts) {
                    ctx.start();
                }
                this.startTimeRef.set(DateTimeUtils.gmtNow());
                this.startedFuture.complete(true);
            }
            Iterator<EndpointContext> iterator = this.runningIndicator;
            return iterator;
        }
        finally {
            this.startStopLock.unlock();
        }
    }

    public static ServiceBuilder builder() {
        return new ServiceBuilder();
    }

    public void stop() {
        this.stop(true, null);
    }

    public void stop(Throwable t) {
        this.stop(true, t);
    }

    public void stop(boolean drain) {
        this.stop(drain, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean drain, Throwable t) {
        this.startStopLock.lock();
        try {
            if (this.runningIndicator != null) {
                if (drain) {
                    ArrayList<CompletableFuture<Boolean>> futures = new ArrayList<CompletableFuture<Boolean>>();
                    for (Dispatcher d : this.dInternals) {
                        try {
                            futures.add(d.drain(this.drainTimeout));
                        }
                        catch (Exception exception) {}
                    }
                    for (EndpointContext c : this.serviceContexts.values()) {
                        if (!c.isNotInternalDispatcher()) continue;
                        try {
                            futures.add(c.drain(this.drainTimeout));
                        }
                        catch (Exception exception) {}
                    }
                    for (EndpointContext c : this.discoveryContexts) {
                        if (!c.isNotInternalDispatcher()) continue;
                        try {
                            futures.add(c.drain(this.drainTimeout));
                        }
                        catch (Exception exception) {}
                    }
                    long drainTimeoutMillis = this.drainTimeout.toMillis();
                    for (CompletableFuture completableFuture : futures) {
                        try {
                            completableFuture.get(drainTimeoutMillis, TimeUnit.MILLISECONDS);
                        }
                        catch (Exception exception) {}
                    }
                }
                for (Dispatcher d : this.dInternals) {
                    this.conn.closeDispatcher(d);
                }
                if (t == null) {
                    this.runningIndicator.complete(true);
                } else {
                    this.runningIndicator.completeExceptionally(t);
                }
                this.runningIndicator = null;
            }
        }
        finally {
            this.startStopLock.unlock();
        }
    }

    public void reset() {
        if (this.isStarted()) {
            this.startTimeRef.set(DateTimeUtils.gmtNow());
        }
        for (EndpointContext c : this.discoveryContexts) {
            c.reset();
        }
        for (EndpointContext c : this.serviceContexts.values()) {
            c.reset();
        }
    }

    public String getId() {
        return this.infoResponse.getId();
    }

    public String getName() {
        return this.infoResponse.getName();
    }

    public String getVersion() {
        return this.infoResponse.getVersion();
    }

    public String getDescription() {
        return this.infoResponse.getDescription();
    }

    public boolean isStarted() {
        return this.startedFuture.isDone();
    }

    public boolean isStarted(long timeout, TimeUnit unit) {
        try {
            return this.startedFuture.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException | TimeoutException e) {
            return false;
        }
    }

    public Duration getDrainTimeout() {
        return this.drainTimeout;
    }

    public PingResponse getPingResponse() {
        return this.pingResponse;
    }

    public InfoResponse getInfoResponse() {
        return this.infoResponse;
    }

    public StatsResponse getStatsResponse() {
        ArrayList<EndpointStats> endpointStats = new ArrayList<EndpointStats>();
        for (EndpointContext c : this.serviceContexts.values()) {
            endpointStats.add(c.getEndpointStats());
        }
        return new StatsResponse(this.pingResponse, this.startTimeRef.get(), endpointStats);
    }

    public EndpointStats getEndpointStats(String endpointName) {
        EndpointContext c = this.serviceContexts.get(endpointName);
        return c == null ? null : c.getEndpointStats();
    }

    public String toString() {
        StringBuilder sb = JsonUtils.beginJsonPrefixed("\"Service\":");
        JsonUtils.addField(sb, "id", this.infoResponse.getId());
        JsonUtils.addField(sb, "name", this.infoResponse.getName());
        JsonUtils.addField(sb, "version", this.infoResponse.getVersion());
        JsonUtils.addField(sb, "description", this.infoResponse.getDescription());
        JsonUtils.addField(sb, "started", this.startTimeRef.get());
        return JsonUtils.endJson(sb).toString();
    }
}

