/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.impl.Headers;
import io.nats.client.impl.IncomingMessage;
import io.nats.client.impl.NatsJetStreamMessage;
import io.nats.client.impl.NatsMessage;
import io.nats.client.impl.StatusMessage;
import io.nats.client.support.IncomingHeadersProcessor;
import io.nats.client.support.Status;

class IncomingMessageFactory {
    private final String sid;
    private final String subject;
    private final String replyTo;
    private final int protocolLineLength;
    private final boolean utf8mode;
    private byte[] data;
    private Headers headers;
    private Status status;
    private int headerLen;

    IncomingMessageFactory(String sid, String subject, String replyTo, int protocolLength, boolean utf8mode) {
        this.sid = sid;
        this.subject = subject;
        this.replyTo = replyTo;
        this.protocolLineLength = protocolLength;
        this.utf8mode = utf8mode;
    }

    void setHeaders(IncomingHeadersProcessor ihp) {
        this.headers = ihp.getHeaders();
        this.status = ihp.getStatus();
        this.headerLen = ihp.getSerializedLength();
    }

    void setData(byte[] data) {
        this.data = data;
    }

    NatsMessage getMessage() {
        IncomingMessage message = this.status != null ? new StatusMessage(this.status) : (this.replyTo != null && this.replyTo.startsWith("$JS.ACK.") ? new NatsJetStreamMessage(this.data) : new IncomingMessage(this.data));
        message.sid = this.sid;
        message.subject = this.subject;
        message.replyTo = this.replyTo;
        message.headers = this.headers;
        message.headerLen = this.headerLen;
        message.sizeInBytes = this.protocolLineLength + this.headerLen + message.dataLen + 4;
        return message;
    }
}

