/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.support.ByteArrayBuilder;
import io.nats.client.support.NatsConstants;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class Headers {
    private static final String KEY_CANNOT_BE_EMPTY_OR_NULL = "Header key cannot be null.";
    private static final String KEY_INVALID_CHARACTER = "Header key has invalid character: 0x";
    private static final String VALUE_INVALID_CHARACTERS = "Header value has invalid character: 0x";
    private final Map<String, List<String>> valuesMap;
    private final Map<String, Integer> lengthMap;
    private final boolean readOnly;
    private byte[] serialized;
    private int dataLength;
    private static final int HVCRLF_BYTES = NatsConstants.HEADER_VERSION_BYTES_PLUS_CRLF.length;
    private static final int NON_DATA_BYTES = HVCRLF_BYTES + 2;

    public Headers() {
        this(null, false, null);
    }

    public Headers(@Nullable Headers headers) {
        this(headers, false, null);
    }

    public Headers(@Nullable Headers headers, boolean readOnly) {
        this(headers, readOnly, null);
    }

    public Headers(@Nullable Headers headers, boolean readOnly, String @Nullable [] keysNotToCopy) {
        HashMap<String, List<String>> tempValuesMap = new HashMap<String, List<String>>();
        HashMap<String, Integer> tempLengthMap = new HashMap<String, Integer>();
        if (headers != null) {
            tempValuesMap.putAll(headers.valuesMap);
            tempLengthMap.putAll(headers.lengthMap);
            this.dataLength = headers.dataLength;
            if (keysNotToCopy != null) {
                for (String key : keysNotToCopy) {
                    if (key == null || tempValuesMap.remove(key) == null) continue;
                    this.dataLength -= ((Integer)tempLengthMap.remove(key)).intValue();
                }
            }
        }
        this.readOnly = readOnly;
        if (readOnly) {
            this.valuesMap = Collections.unmodifiableMap(tempValuesMap);
            this.lengthMap = Collections.unmodifiableMap(tempLengthMap);
        } else {
            this.valuesMap = tempValuesMap;
            this.lengthMap = tempLengthMap;
        }
    }

    public Headers add(String key, String ... values) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        if (values == null || values.length == 0) {
            return this;
        }
        return this._add(key, Arrays.asList(values));
    }

    public Headers add(String key, Collection<String> values) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        if (values == null || values.isEmpty()) {
            return this;
        }
        return this._add(key, values);
    }

    private Headers _add(String key, Collection<String> values) {
        Checker checked;
        if (values != null && (checked = new Checker(key, values)).hasValues()) {
            List currentSet = this.valuesMap.computeIfAbsent(key, k -> new ArrayList());
            currentSet.addAll(checked.list);
            this.dataLength += checked.len;
            int oldLen = this.lengthMap.getOrDefault(key, 0);
            this.lengthMap.put(key, oldLen + checked.len);
            this.serialized = null;
        }
        return this;
    }

    public Headers put(String key, String ... values) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        if (values == null || values.length == 0) {
            return this;
        }
        return this._put(key, Arrays.asList(values));
    }

    public Headers put(String key, Collection<String> values) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        if (values == null || values.isEmpty()) {
            return this;
        }
        return this._put(key, values);
    }

    public Headers put(Map<String, List<String>> map) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        if (map == null || map.isEmpty()) {
            return this;
        }
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            this._put(entry.getKey(), (Collection<String>)entry.getValue());
        }
        return this;
    }

    private Headers _put(String key, Collection<String> values) {
        Checker checked;
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty.");
        }
        if (values != null && (checked = new Checker(key, values)).hasValues()) {
            this.dataLength = this.dataLength - this.lengthMap.getOrDefault(key, 0) + checked.len;
            this.valuesMap.put(key, checked.list);
            this.lengthMap.put(key, checked.len);
            this.serialized = null;
        }
        return this;
    }

    public void remove(String ... keys) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        for (String key : keys) {
            this._remove(key);
        }
        this.serialized = null;
    }

    public void remove(Collection<String> keys) {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        for (String key : keys) {
            this._remove(key);
        }
        this.serialized = null;
    }

    private void _remove(String key) {
        if (this.valuesMap.remove(key) != null) {
            this.dataLength -= this.lengthMap.remove(key).intValue();
        }
    }

    public int size() {
        return this.valuesMap.size();
    }

    public boolean isEmpty() {
        return this.valuesMap.isEmpty();
    }

    public void clear() {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
        this.valuesMap.clear();
        this.lengthMap.clear();
        this.dataLength = 0;
        this.serialized = null;
    }

    public boolean containsKey(String key) {
        return this.valuesMap.containsKey(key);
    }

    public boolean containsKeyIgnoreCase(String key) {
        for (String k : this.valuesMap.keySet()) {
            if (!k.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.valuesMap.keySet());
    }

    public Set<String> keySetIgnoreCase() {
        HashSet<String> set = new HashSet<String>();
        for (String k : this.valuesMap.keySet()) {
            set.add(k.toLowerCase());
        }
        return Collections.unmodifiableSet(set);
    }

    public @Nullable List<String> get(String key) {
        List<String> values = this.valuesMap.get(key);
        return values == null ? null : Collections.unmodifiableList(values);
    }

    public @Nullable String getFirst(String key) {
        List<String> values = this.valuesMap.get(key);
        return values == null ? null : values.get(0);
    }

    public @Nullable String getLast(String key) {
        List<String> values = this.valuesMap.get(key);
        return values == null ? null : values.get(values.size() - 1);
    }

    public @Nullable List<String> getIgnoreCase(String key) {
        ArrayList values = new ArrayList();
        for (Map.Entry<String, List<String>> entry : this.valuesMap.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(key)) continue;
            values.addAll(entry.getValue());
        }
        return values.isEmpty() ? null : Collections.unmodifiableList(values);
    }

    public void forEach(BiConsumer<String, List<String>> action) {
        for (Map.Entry<String, List<String>> entry : this.valuesMap.entrySet()) {
            action.accept(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
    }

    public @NonNull Set<Map.Entry<String, List<String>>> entrySet() {
        return this.valuesMap.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(this.valuesMap.entrySet());
    }

    public boolean isDirty() {
        return this.serialized == null;
    }

    public int serializedLength() {
        return this.dataLength + NON_DATA_BYTES;
    }

    public byte @NonNull [] getSerialized() {
        if (this.serialized == null) {
            this.serialized = new byte[this.serializedLength()];
            this.serializeToArray(0, this.serialized);
        }
        return this.serialized;
    }

    @Deprecated
    public ByteArrayBuilder appendSerialized(ByteArrayBuilder bab) {
        bab.append(NatsConstants.HEADER_VERSION_BYTES_PLUS_CRLF);
        for (Map.Entry<String, List<String>> entry : this.valuesMap.entrySet()) {
            for (String value : entry.getValue()) {
                bab.append(entry.getKey());
                bab.append(NatsConstants.COLON_BYTES);
                bab.append(value);
                bab.append(NatsConstants.CRLF_BYTES);
            }
        }
        bab.append(NatsConstants.CRLF_BYTES);
        return bab;
    }

    public int serializeToArray(int destPosition, byte[] dest) {
        System.arraycopy(NatsConstants.HEADER_VERSION_BYTES_PLUS_CRLF, 0, dest, destPosition, HVCRLF_BYTES);
        destPosition += HVCRLF_BYTES;
        for (Map.Entry<String, List<String>> entry : this.valuesMap.entrySet()) {
            String key = entry.getKey();
            for (String value : entry.getValue()) {
                key.getBytes(0, key.length(), dest, destPosition);
                destPosition += key.length();
                dest[destPosition++] = 58;
                value.getBytes(0, value.length(), dest, destPosition);
                destPosition += value.length();
                dest[destPosition++] = 13;
                dest[destPosition++] = 10;
            }
        }
        dest[destPosition++] = 13;
        dest[destPosition] = 10;
        return this.serializedLength();
    }

    static void checkKey(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException(KEY_CANNOT_BE_EMPTY_OR_NULL);
        }
        int len = key.length();
        for (int idx = 0; idx < len; ++idx) {
            char c = key.charAt(idx);
            if (c >= '!' && c <= '~' && c != ':') continue;
            throw new IllegalArgumentException(KEY_INVALID_CHARACTER + Integer.toHexString(c));
        }
    }

    static void checkValue(String val) {
        int len = val.length();
        for (int i = 0; i < len; ++i) {
            char c = val.charAt(i);
            if (c <= '\u007f' && c != '\n' && c != '\r') continue;
            throw new IllegalArgumentException(VALUE_INVALID_CHARACTERS + Integer.toHexString(c));
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Headers)) {
            return false;
        }
        Headers headers = (Headers)o;
        return Objects.equals(this.valuesMap, headers.valuesMap);
    }

    public int hashCode() {
        return Objects.hashCode(this.valuesMap);
    }

    public String toString() {
        byte[] b = this.getSerialized();
        int len = b.length;
        if (len <= HVCRLF_BYTES + 2) {
            return "";
        }
        block4: for (int i = 0; i < len; ++i) {
            switch (b[i]) {
                case 13: {
                    b[i] = 59;
                    continue block4;
                }
                case 10: {
                    b[i] = 32;
                }
            }
        }
        return new String(b, HVCRLF_BYTES, len - HVCRLF_BYTES - 3, StandardCharsets.ISO_8859_1);
    }

    private static final class Checker {
        List<String> list = new ArrayList<String>();
        int len = 0;

        Checker(String key, Collection<String> values) {
            Headers.checkKey(key);
            if (!values.isEmpty()) {
                for (String val : values) {
                    if (val == null) continue;
                    if (val.isEmpty()) {
                        this.list.add(val);
                        this.len += key.length() + 3;
                        continue;
                    }
                    Headers.checkValue(val);
                    this.list.add(val);
                    this.len += key.length() + val.length() + 3;
                }
            }
        }

        boolean hasValues() {
            return !this.list.isEmpty();
        }
    }
}

