/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class StreamInfoOptions
implements JsonSerializable {
    private final String subjectsFilter;
    private final boolean deletedDetails;

    private StreamInfoOptions(String subjectsFilter, boolean deletedDetails) {
        this.subjectsFilter = subjectsFilter;
        this.deletedDetails = deletedDetails;
    }

    public @Nullable String getSubjectsFilter() {
        return this.subjectsFilter;
    }

    public boolean isDeletedDetails() {
        return this.deletedDetails;
    }

    public static StreamInfoOptions filterSubjects(String subjectsFilter) {
        return new Builder().filterSubjects(subjectsFilter).build();
    }

    public static StreamInfoOptions allSubjects() {
        return new Builder().allSubjects().build();
    }

    public static StreamInfoOptions deletedDetails() {
        return new Builder().deletedDetails().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public @NonNull String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "subjects_filter", this.subjectsFilter);
        JsonUtils.addFldWhenTrue(sb, "deleted_details", this.deletedDetails);
        return JsonUtils.endJson(sb).toString();
    }

    public static class Builder {
        private String subjectsFilter;
        private boolean deletedDetails;

        public Builder filterSubjects(String subjectsFilter) {
            this.subjectsFilter = Validator.emptyAsNull(subjectsFilter);
            return this;
        }

        public Builder allSubjects() {
            this.subjectsFilter = ">";
            return this;
        }

        public Builder deletedDetails() {
            this.deletedDetails = true;
            return this;
        }

        public StreamInfoOptions build() {
            return new StreamInfoOptions(this.subjectsFilter, this.deletedDetails);
        }
    }
}

