/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonParseException;
import io.nats.client.support.JsonParser;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.ServerVersion;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ServerInfo {
    public static final ServerInfo EMPTY_INFO = new ServerInfo("INFO {}");
    private final String serverId;
    private final String serverName;
    private final String version;
    private final String go;
    private final String host;
    private final int port;
    private final boolean headersSupported;
    private final boolean authRequired;
    private final boolean tlsRequired;
    private final boolean tlsAvailable;
    private final long maxPayload;
    private final List<String> connectURLs;
    private final int protocolVersion;
    private final byte[] nonce;
    private final boolean lameDuckMode;
    private final boolean jetStream;
    private final int clientId;
    private final String clientIp;
    private final String cluster;

    public ServerInfo(String json) {
        JsonValue jv;
        if (json == null || json.length() < 6 || '{' != json.charAt(0) && '{' != json.charAt(5)) {
            throw new IllegalArgumentException("Invalid Server Info");
        }
        try {
            jv = JsonParser.parse(json, json.indexOf("{"));
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("Invalid Server Info Json");
        }
        this.serverId = JsonValueUtils.readString(jv, "server_id", "UNDEFINED");
        this.serverName = JsonValueUtils.readString(jv, "server_name", "UNDEFINED");
        this.version = JsonValueUtils.readString(jv, "version", "0.0.0");
        this.go = JsonValueUtils.readString(jv, "go", "0.0.0");
        this.host = JsonValueUtils.readString(jv, "host", "UNDEFINED");
        this.headersSupported = JsonValueUtils.readBoolean(jv, "headers");
        this.authRequired = JsonValueUtils.readBoolean(jv, "auth_required");
        this.nonce = JsonValueUtils.readBytes(jv, "nonce");
        this.tlsRequired = JsonValueUtils.readBoolean(jv, "tls_required");
        this.tlsAvailable = JsonValueUtils.readBoolean(jv, "tls_available");
        this.lameDuckMode = JsonValueUtils.readBoolean(jv, "ldm");
        this.jetStream = JsonValueUtils.readBoolean(jv, "jetstream");
        this.port = JsonValueUtils.readInteger(jv, "port", 0);
        this.protocolVersion = JsonValueUtils.readInteger(jv, "proto", 0);
        this.maxPayload = JsonValueUtils.readLong(jv, "max_payload", 0L);
        this.clientId = JsonValueUtils.readInteger(jv, "client_id", 0);
        this.clientIp = JsonValueUtils.readString(jv, "client_ip", "0.0.0.0");
        this.cluster = JsonValueUtils.readString(jv, "cluster");
        this.connectURLs = JsonValueUtils.readStringListIgnoreEmpty(jv, "connect_urls");
    }

    public boolean isLameDuckMode() {
        return this.lameDuckMode;
    }

    public @NonNull String getServerId() {
        return this.serverId;
    }

    public @NonNull String getServerName() {
        return this.serverName;
    }

    public @NonNull String getVersion() {
        return this.version;
    }

    public @NonNull String getGoVersion() {
        return this.go;
    }

    public @NonNull String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public boolean isHeadersSupported() {
        return this.headersSupported;
    }

    public boolean isAuthRequired() {
        return this.authRequired;
    }

    public boolean isTLSRequired() {
        return this.tlsRequired;
    }

    public boolean isTLSAvailable() {
        return this.tlsAvailable;
    }

    public long getMaxPayload() {
        return this.maxPayload;
    }

    public @NonNull List<String> getConnectURLs() {
        return this.connectURLs;
    }

    public byte @Nullable [] getNonce() {
        return this.nonce;
    }

    public boolean isJetStreamAvailable() {
        return this.jetStream;
    }

    public int getClientId() {
        return this.clientId;
    }

    public @NonNull String getClientIp() {
        return this.clientIp;
    }

    public @Nullable String getCluster() {
        return this.cluster;
    }

    public boolean isNewerVersionThan(String vTarget) {
        return ServerVersion.isNewer(this.version, vTarget);
    }

    public boolean isSameVersion(String vTarget) {
        return ServerVersion.isSame(this.version, vTarget);
    }

    public boolean isOlderThanVersion(String vTarget) {
        return ServerVersion.isOlder(this.version, vTarget);
    }

    public boolean isSameOrOlderThanVersion(String vTarget) {
        return ServerVersion.isSameOrOlder(this.version, vTarget);
    }

    public boolean isSameOrNewerThanVersion(String vTarget) {
        return ServerVersion.isSameOrNewer(this.version, vTarget);
    }

    public String toString() {
        return "ServerInfo{serverId='" + this.serverId + '\'' + ", serverName='" + this.serverName + '\'' + ", version='" + this.version + '\'' + ", go='" + this.go + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", headersSupported=" + this.headersSupported + ", authRequired=" + this.authRequired + ", tlsRequired=" + this.tlsRequired + ", tlsAvailable=" + this.tlsAvailable + ", maxPayload=" + this.maxPayload + ", connectURLs=" + this.connectURLs + ", protocolVersion=" + this.protocolVersion + ", nonce=" + Arrays.toString(this.nonce) + ", lameDuckMode=" + this.lameDuckMode + ", jetStream=" + this.jetStream + ", clientId=" + this.clientId + ", clientIp='" + this.clientIp + '\'' + ", cluster='" + this.cluster + '\'' + '}';
    }
}

