/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.JetStreamApiException;
import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.support.JsonValueUtils;
import java.io.IOException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class PublishAck
extends ApiResponse<PublishAck> {
    private final String stream;
    private final long seq;
    private final String domain;
    private final boolean duplicate;
    private final String val;
    private final String batchId;
    private final int batchSize;

    public PublishAck(Message msg) throws IOException, JetStreamApiException {
        super(msg);
        this.throwOnHasError();
        this.stream = JsonValueUtils.readString(this.jv, "stream");
        if (this.stream == null) {
            throw new IOException("Invalid JetStream ack.");
        }
        this.seq = JsonValueUtils.readLong(this.jv, "seq", -1L);
        if (this.seq < 0L) {
            throw new IOException("Invalid JetStream ack.");
        }
        this.domain = JsonValueUtils.readString(this.jv, "domain");
        this.duplicate = JsonValueUtils.readBoolean(this.jv, "duplicate");
        this.val = JsonValueUtils.readString(this.jv, "val");
        this.batchId = JsonValueUtils.readString(this.jv, "batch");
        this.batchSize = JsonValueUtils.readInteger(this.jv, "count", -1);
    }

    public long getSeqno() {
        return this.seq;
    }

    public @NonNull String getStream() {
        return this.stream;
    }

    public @Nullable String getDomain() {
        return this.domain;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public @Nullable String getVal() {
        return this.val;
    }

    public @Nullable String getBatchId() {
        return this.batchId;
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

