/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class External
implements JsonSerializable {
    private final String api;
    private final String deliver;

    static External optionalInstance(JsonValue vExternal) {
        return vExternal == null ? null : new External(vExternal);
    }

    External(JsonValue vExternal) {
        this.api = JsonValueUtils.readString(vExternal, "api");
        this.deliver = JsonValueUtils.readString(vExternal, "deliver");
    }

    public External(String api, String deliver) {
        this.api = api;
        this.deliver = deliver;
    }

    @Override
    public @NonNull String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "api", this.api);
        JsonUtils.addField(sb, "deliver", this.deliver);
        return JsonUtils.endJson(sb).toString();
    }

    public @Nullable String getApi() {
        return this.api;
    }

    public @Nullable String getDeliver() {
        return this.deliver;
    }

    public String toString() {
        return "External{api='" + this.api + '\'' + ", deliver='" + this.deliver + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        External external = (External)o;
        if (this.api != null ? !this.api.equals(external.api) : external.api != null) {
            return false;
        }
        return this.deliver != null ? this.deliver.equals(external.deliver) : external.deliver == null;
    }

    public int hashCode() {
        int result = this.api != null ? this.api.hashCode() : 0;
        result = 31 * result + (this.deliver != null ? this.deliver.hashCode() : 0);
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String api;
        private String deliver;

        public Builder api(String api) {
            this.api = api;
            return this;
        }

        public Builder deliver(String deliver) {
            this.deliver = deliver;
            return this;
        }

        public External build() {
            return new External(this.api, this.deliver);
        }
    }
}

