/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.Message;
import io.nats.client.api.ApiResponse;
import io.nats.client.api.ClusterInfo;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.PriorityGroupState;
import io.nats.client.api.SequenceInfo;
import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ConsumerInfo
extends ApiResponse<ConsumerInfo> {
    private final String stream;
    private final String name;
    private final ConsumerConfiguration configuration;
    private final ZonedDateTime created;
    private final SequenceInfo delivered;
    private final SequenceInfo ackFloor;
    private final long numPending;
    private final long numWaiting;
    private final long numAckPending;
    private final long numRedelivered;
    private final boolean paused;
    private final Duration pauseRemaining;
    private final ClusterInfo clusterInfo;
    private final boolean pushBound;
    private final ZonedDateTime timestamp;
    private final List<PriorityGroupState> priorityGroupStates;

    public ConsumerInfo(Message msg) {
        this(ConsumerInfo.parseMessage(msg));
    }

    public ConsumerInfo(JsonValue vConsumerInfo) {
        super(vConsumerInfo);
        if (this.hasError()) {
            this.configuration = ConsumerConfiguration.builder().build();
            this.stream = "UNDEFINED";
            this.name = "UNDEFINED";
            this.created = DateTimeUtils.DEFAULT_TIME;
            this.delivered = null;
            this.ackFloor = null;
            this.numAckPending = -1L;
            this.numRedelivered = -1L;
            this.numPending = -1L;
            this.numWaiting = -1L;
            this.paused = false;
            this.pauseRemaining = null;
            this.clusterInfo = null;
            this.pushBound = false;
            this.timestamp = null;
            this.priorityGroupStates = null;
        } else {
            JsonValue jvConfig = this.nullValueIsError(this.jv, "config", JsonValue.EMPTY_MAP);
            this.configuration = ConsumerConfiguration.builder().jsonValue(jvConfig).build();
            this.stream = this.nullStringIsError(this.jv, "stream_name");
            this.name = this.nullStringIsError(this.jv, "name");
            this.created = this.nullDateIsError(this.jv, "created");
            this.delivered = new SequenceInfo(JsonValueUtils.readObject(this.jv, "delivered"));
            this.ackFloor = new SequenceInfo(JsonValueUtils.readObject(this.jv, "ack_floor"));
            this.numAckPending = JsonValueUtils.readLong(this.jv, "num_ack_pending", 0L);
            this.numRedelivered = JsonValueUtils.readLong(this.jv, "num_redelivered", 0L);
            this.numPending = JsonValueUtils.readLong(this.jv, "num_pending", 0L);
            this.numWaiting = JsonValueUtils.readLong(this.jv, "num_waiting", 0L);
            this.paused = JsonValueUtils.readBoolean(this.jv, "paused", false);
            this.pauseRemaining = JsonValueUtils.readNanos(this.jv, "pause_remaining");
            this.clusterInfo = ClusterInfo.optionalInstance(JsonValueUtils.readValue(this.jv, "cluster"));
            this.pushBound = JsonValueUtils.readBoolean(this.jv, "push_bound");
            this.timestamp = JsonValueUtils.readDate(this.jv, "ts");
            this.priorityGroupStates = PriorityGroupState.optionalListOf(JsonValueUtils.readObject(this.jv, "priority_groups"));
        }
    }

    public @NonNull ConsumerConfiguration getConsumerConfiguration() {
        return this.configuration;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull String getStreamName() {
        return this.stream;
    }

    public @NonNull ZonedDateTime getCreationTime() {
        return this.created;
    }

    public @NonNull SequenceInfo getDelivered() {
        return this.delivered;
    }

    public @NonNull SequenceInfo getAckFloor() {
        return this.ackFloor;
    }

    public long getNumPending() {
        return this.numPending;
    }

    public long getNumWaiting() {
        return this.numWaiting;
    }

    public long getNumAckPending() {
        return this.numAckPending;
    }

    public long getRedelivered() {
        return this.numRedelivered;
    }

    public boolean getPaused() {
        return this.paused;
    }

    public @Nullable Duration getPauseRemaining() {
        return this.pauseRemaining;
    }

    public @Nullable ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    public boolean isPushBound() {
        return this.pushBound;
    }

    public @Nullable ZonedDateTime getTimestamp() {
        return this.timestamp;
    }

    public @Nullable List<PriorityGroupState> getPriorityGroupStates() {
        return this.priorityGroupStates;
    }

    public long getCalculatedPending() {
        return this.numPending + this.delivered.getConsumerSequence();
    }
}

