/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import java.time.Duration;

public class PeerInfo {
    private final String name;
    private final boolean current;
    private final boolean offline;
    private final Duration active;
    private final long lag;

    PeerInfo(JsonValue vPeerInfo) {
        this.name = JsonValueUtils.readString(vPeerInfo, "name");
        this.current = JsonValueUtils.readBoolean(vPeerInfo, "current");
        this.offline = JsonValueUtils.readBoolean(vPeerInfo, "offline");
        this.active = JsonValueUtils.readNanos(vPeerInfo, "active", Duration.ZERO);
        this.lag = JsonValueUtils.readLong(vPeerInfo, "lag", 0L);
    }

    public String getName() {
        return this.name;
    }

    public boolean isCurrent() {
        return this.current;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public Duration getActive() {
        return this.active;
    }

    public long getLag() {
        return this.lag;
    }
}

