/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.Connection;
import io.nats.client.Dispatcher;
import io.nats.client.support.Validator;
import io.nats.service.Service;
import io.nats.service.ServiceEndpoint;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

public class ServiceBuilder {
    public static final long DEFAULT_DRAIN_TIMEOUT_MILLIS = 5000L;
    public static final Duration DEFAULT_DRAIN_TIMEOUT = Duration.ofMillis(5000L);
    Connection conn;
    String name;
    String description;
    String version;
    Map<String, String> metadata;
    final Map<String, ServiceEndpoint> serviceEndpoints = new HashMap<String, ServiceEndpoint>();
    Duration drainTimeout = DEFAULT_DRAIN_TIMEOUT;
    Dispatcher pingDispatcher;
    Dispatcher infoDispatcher;
    Dispatcher schemaDispatcher;
    Dispatcher statsDispatcher;

    public ServiceBuilder connection(Connection conn) {
        this.conn = conn;
        return this;
    }

    public ServiceBuilder name(String name) {
        this.name = Validator.validateIsRestrictedTerm(name, "Service Name", true);
        return this;
    }

    public ServiceBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ServiceBuilder version(String version) {
        this.version = Validator.validateSemVer(version, "Service Version", true);
        return this;
    }

    public ServiceBuilder metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public ServiceBuilder addServiceEndpoint(ServiceEndpoint serviceEndpoint) {
        this.serviceEndpoints.put(serviceEndpoint.getName(), serviceEndpoint);
        return this;
    }

    public ServiceBuilder drainTimeout(Duration drainTimeout) {
        this.drainTimeout = drainTimeout == null ? DEFAULT_DRAIN_TIMEOUT : drainTimeout;
        return this;
    }

    public ServiceBuilder drainTimeout(long drainTimeoutMillis) {
        this.drainTimeout = Duration.ofMillis(drainTimeoutMillis);
        return this;
    }

    public ServiceBuilder pingDispatcher(Dispatcher pingDispatcher) {
        this.pingDispatcher = pingDispatcher;
        return this;
    }

    public ServiceBuilder infoDispatcher(Dispatcher infoDispatcher) {
        this.infoDispatcher = infoDispatcher;
        return this;
    }

    public ServiceBuilder schemaDispatcher(Dispatcher schemaDispatcher) {
        this.schemaDispatcher = schemaDispatcher;
        return this;
    }

    public ServiceBuilder statsDispatcher(Dispatcher statsDispatcher) {
        this.statsDispatcher = statsDispatcher;
        return this;
    }

    public Service build() {
        Validator.required(this.conn, "Connection");
        Validator.required(this.name, "Name");
        Validator.required(this.version, "Version");
        Validator.required(this.serviceEndpoints, "Service Endpoints");
        return new Service(this);
    }
}

