/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Endpoint
implements JsonSerializable {
    private static final String DEFAULT_QGROUP = "q";
    private final String name;
    private final String subject;
    private final String queueGroup;
    private final Map<String, String> metadata;

    public Endpoint(String name) {
        this(name, null, null, null, true);
    }

    public Endpoint(String name, Map<String, String> metadata) {
        this(name, null, null, metadata, true);
    }

    public Endpoint(String name, String subject) {
        this(name, subject, null, null, true);
    }

    public Endpoint(String name, String subject, Map<String, String> metadata) {
        this(name, subject, null, metadata, true);
    }

    public Endpoint(String name, String subject, String queueGroup, Map<String, String> metadata) {
        this(name, subject, queueGroup, metadata, true);
    }

    Endpoint(String name, String subject, String queueGroup, Map<String, String> metadata, boolean validate) {
        if (validate) {
            this.name = Validator.validateIsRestrictedTerm(name, "Endpoint Name", true);
            this.subject = subject == null ? this.name : Validator.validateSubjectTerm(subject, "Endpoint Subject", false);
            this.queueGroup = queueGroup == null ? DEFAULT_QGROUP : Validator.validateSubjectTerm(queueGroup, "Endpoint Queue Group", true);
        } else {
            this.name = name;
            this.subject = subject;
            this.queueGroup = queueGroup;
        }
        this.metadata = metadata == null || metadata.isEmpty() ? null : metadata;
    }

    Endpoint(JsonValue vEndpoint) {
        this.name = JsonValueUtils.readString(vEndpoint, "name");
        this.subject = JsonValueUtils.readString(vEndpoint, "subject");
        this.queueGroup = JsonValueUtils.readString(vEndpoint, "queue_group");
        this.metadata = JsonValueUtils.readStringStringMap(vEndpoint, "metadata");
    }

    Endpoint(Builder b) {
        this(b.name, b.subject, b.queueGroup, b.metadata, true);
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "name", this.name);
        JsonUtils.addField(sb, "subject", this.subject);
        JsonUtils.addField(sb, "queue_group", this.queueGroup);
        JsonUtils.addField(sb, "metadata", this.metadata);
        return JsonUtils.endJson(sb).toString();
    }

    public String toString() {
        return JsonUtils.toKey(this.getClass()) + this.toJson();
    }

    public String getName() {
        return this.name;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getQueueGroup() {
        return this.queueGroup;
    }

    public Map<String, String> getMetadata() {
        return this.metadata == null ? null : new HashMap<String, String>(this.metadata);
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        if (!Objects.equals(this.name, endpoint.name)) {
            return false;
        }
        if (!Objects.equals(this.subject, endpoint.subject)) {
            return false;
        }
        if (!Objects.equals(this.queueGroup, endpoint.queueGroup)) {
            return false;
        }
        return Objects.equals(this.metadata, endpoint.metadata);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
        result = 31 * result + (this.queueGroup != null ? this.queueGroup.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String name;
        private String subject;
        private String queueGroup = "q";
        private Map<String, String> metadata;

        public Builder endpoint(Endpoint endpoint) {
            return this.name(endpoint.getName()).subject(endpoint.getSubject()).queueGroup(endpoint.getQueueGroup()).metadata(endpoint.getMetadata());
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder queueGroup(String queueGroup) {
            this.queueGroup = queueGroup == null ? Endpoint.DEFAULT_QGROUP : queueGroup;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata == null || metadata.isEmpty() ? null : new HashMap<String, String>(metadata);
            return this;
        }

        public Endpoint build() {
            return new Endpoint(this);
        }
    }
}

