/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.AuthHandler;
import io.nats.client.NKey;

class StringAuthHandler
implements AuthHandler {
    private final char[] nkey;
    private final char[] jwt;

    StringAuthHandler(char[] jwt, char[] nkey) {
        this.jwt = jwt;
        this.nkey = nkey;
    }

    @Override
    public byte[] sign(byte[] nonce) {
        try {
            NKey nkey = NKey.fromSeed(this.nkey);
            byte[] sig = nkey.sign(nonce);
            nkey.clear();
            return sig;
        }
        catch (Exception exp) {
            throw new IllegalStateException("problem signing nonce", exp);
        }
    }

    @Override
    public char[] getID() {
        try {
            NKey nkey = NKey.fromSeed(this.nkey);
            char[] pubKey = nkey.getPublicKey();
            nkey.clear();
            return pubKey;
        }
        catch (Exception exp) {
            throw new IllegalStateException("problem getting public key", exp);
        }
    }

    @Override
    public char[] getJWT() {
        return this.jwt;
    }
}

