/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamReader;
import io.nats.client.JetStreamStatusException;
import io.nats.client.Message;
import io.nats.client.PullRequestOptions;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.NatsMessage;
import io.nats.client.impl.PullManagerObserver;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class NatsJetStreamPullSubscription
extends NatsJetStreamSubscription {
    private final AtomicLong pullSubjectIdHolder = new AtomicLong();

    NatsJetStreamPullSubscription(String sid, String subject, NatsConnection connection, NatsDispatcher dispatcher, NatsJetStream js, String stream, String consumer, MessageManager manager) {
        super(sid, subject, null, connection, dispatcher, js, stream, consumer, manager);
    }

    @Override
    boolean isPullMode() {
        return true;
    }

    @Override
    public void pull(int batchSize) {
        this._pull(PullRequestOptions.builder(batchSize).build(), true, null);
    }

    @Override
    public void pull(PullRequestOptions pullRequestOptions) {
        this._pull(pullRequestOptions, true, null);
    }

    protected String _pull(PullRequestOptions pullRequestOptions, boolean raiseStatusWarnings, PullManagerObserver pullManagerObserver) {
        String publishSubject = this.js.prependPrefix(String.format("CONSUMER.MSG.NEXT.%s.%s", this.stream, this.consumerName));
        String pullSubject = this.getSubject().replace("*", Long.toString(this.pullSubjectIdHolder.incrementAndGet()));
        this.manager.startPullRequest(pullSubject, pullRequestOptions, raiseStatusWarnings, pullManagerObserver);
        this.connection.publishInternal(publishSubject, pullSubject, null, pullRequestOptions.serialize(), true, this.connection.forceFlushOnRequest);
        return pullSubject;
    }

    @Override
    public void pullNoWait(int batchSize) {
        this._pull(PullRequestOptions.noWait(batchSize).build(), true, null);
    }

    @Override
    public void pullNoWait(int batchSize, Duration expiresIn) {
        this.durationGtZeroRequired(expiresIn, "NoWait Expires In");
        this._pull(PullRequestOptions.noWait(batchSize).expiresIn(expiresIn).build(), true, null);
    }

    @Override
    public void pullNoWait(int batchSize, long expiresInMillis) {
        this.durationGtZeroRequired(expiresInMillis, "NoWait Expires In");
        this._pull(PullRequestOptions.noWait(batchSize).expiresIn(expiresInMillis).build(), true, null);
    }

    @Override
    public void pullExpiresIn(int batchSize, Duration expiresIn) {
        this.durationGtZeroRequired(expiresIn, "Expires In");
        this._pull(PullRequestOptions.builder(batchSize).expiresIn(expiresIn).build(), true, null);
    }

    @Override
    public void pullExpiresIn(int batchSize, long expiresInMillis) {
        this.durationGtZeroRequired(expiresInMillis, "Expires In");
        this._pull(PullRequestOptions.builder(batchSize).expiresIn(expiresInMillis).build(), true, null);
    }

    @Override
    public List<Message> fetch(int batchSize, long maxWaitMillis) {
        this.durationGtZeroRequired(maxWaitMillis, "Fetch");
        return this._fetch(batchSize, maxWaitMillis);
    }

    @Override
    public List<Message> fetch(int batchSize, Duration maxWait) {
        this.durationGtZeroRequired(maxWait, "Fetch");
        return this._fetch(batchSize, maxWait.toMillis());
    }

    private List<Message> _fetch(int batchSize, long maxWaitMillis) {
        List<Message> messages = this.drainAlreadyBuffered(batchSize);
        int batchLeft = batchSize - messages.size();
        if (batchLeft == 0) {
            return messages;
        }
        try {
            long maxWaitNanos;
            long start = System.nanoTime();
            Duration expires = Duration.ofMillis(maxWaitMillis > 20L ? maxWaitMillis - 10L : maxWaitMillis);
            String pullSubject = this._pull(PullRequestOptions.builder(batchLeft).expiresIn(expires).build(), false, null);
            long timeLeftNanos = maxWaitNanos = maxWaitMillis * 1000000L;
            while (batchLeft > 0 && timeLeftNanos > 0L) {
                NatsMessage msg = this.nextMessageInternal(Duration.ofNanos(timeLeftNanos));
                if (msg == null) {
                    return messages;
                }
                switch (this.manager.manage(msg)) {
                    case MESSAGE: {
                        messages.add(msg);
                        --batchLeft;
                        break;
                    }
                    case STATUS_TERMINUS: {
                        if (!pullSubject.equals(msg.getSubject())) break;
                        return messages;
                    }
                    case STATUS_ERROR: {
                        if (!pullSubject.equals(msg.getSubject())) break;
                        throw new JetStreamStatusException(msg.getStatus(), this);
                    }
                }
                timeLeftNanos = maxWaitNanos - (System.nanoTime() - start);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return messages;
    }

    private List<Message> drainAlreadyBuffered(int batchSize) {
        ArrayList<Message> messages = new ArrayList<Message>(batchSize);
        try {
            while (true) {
                NatsMessage msg;
                if ((msg = this.nextMessageInternal(null)) == null) {
                    return messages;
                }
                if (this.manager.manage(msg) != MessageManager.ManageResult.MESSAGE) continue;
                messages.add(msg);
                if (messages.size() == batchSize) break;
            }
            return messages;
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            return messages;
        }
    }

    private void durationGtZeroRequired(Duration duration, String label) {
        if (duration == null || duration.toMillis() <= 0L) {
            throw new IllegalArgumentException(label + " wait duration must be supplied and greater than 0.");
        }
    }

    private void durationGtZeroRequired(long millis, String label) {
        if (millis <= 0L) {
            throw new IllegalArgumentException(label + " wait duration must be supplied and greater than 0.");
        }
    }

    @Override
    public Iterator<Message> iterate(int batchSize, Duration maxWait) {
        this.durationGtZeroRequired(maxWait, "Iterate");
        return this._iterate(batchSize, maxWait.toMillis());
    }

    @Override
    public Iterator<Message> iterate(int batchSize, long maxWaitMillis) {
        this.durationGtZeroRequired(maxWaitMillis, "Iterate");
        return this._iterate(batchSize, maxWaitMillis);
    }

    private Iterator<Message> _iterate(final int batchSize, long maxWaitMillis) {
        final List<Message> buffered = this.drainAlreadyBuffered(batchSize);
        int batchLeft = batchSize - buffered.size();
        if (batchLeft == 0) {
            return new Iterator<Message>(){

                @Override
                public boolean hasNext() {
                    return buffered.size() > 0;
                }

                @Override
                public Message next() {
                    return (Message)buffered.remove(0);
                }
            };
        }
        final String pullSubject = this._pull(PullRequestOptions.builder(batchLeft).expiresIn(maxWaitMillis).build(), false, null);
        final long timeout = maxWaitMillis;
        return new Iterator<Message>(){
            int received = 0;
            boolean done = false;
            Message msg = null;

            @Override
            public boolean hasNext() {
                try {
                    if (this.msg != null) {
                        return true;
                    }
                    if (this.done) {
                        return false;
                    }
                    if (buffered.isEmpty()) {
                        this.msg = NatsJetStreamPullSubscription.this._nextUnmanaged(timeout, pullSubject);
                        if (this.msg == null) {
                            this.done = true;
                            return false;
                        }
                    } else {
                        this.msg = (Message)buffered.remove(0);
                    }
                    this.done = ++this.received == batchSize;
                    return true;
                }
                catch (InterruptedException e) {
                    this.msg = null;
                    this.done = true;
                    Thread.currentThread().interrupt();
                    return false;
                }
            }

            @Override
            public Message next() {
                Message next = this.msg;
                this.msg = null;
                return next;
            }
        };
    }

    @Override
    public JetStreamReader reader(int batchSize, int repullAt) {
        return new JetStreamReaderImpl(this, batchSize, repullAt);
    }

    static class JetStreamReaderImpl
    implements JetStreamReader {
        private final NatsJetStreamPullSubscription sub;
        private final int batchSize;
        private final int repullAt;
        private int currentBatchRed;
        private boolean keepGoing = true;

        public JetStreamReaderImpl(NatsJetStreamPullSubscription sub, int batchSize, int repullAt) {
            this.sub = sub;
            this.batchSize = batchSize;
            this.repullAt = Math.max(1, Math.min(batchSize, repullAt));
            this.currentBatchRed = 0;
            sub.pull(batchSize);
        }

        @Override
        public Message nextMessage(Duration timeout) throws InterruptedException, IllegalStateException {
            return this.track(this.sub.nextMessage(timeout));
        }

        @Override
        public Message nextMessage(long timeoutMillis) throws InterruptedException, IllegalStateException {
            return this.track(this.sub.nextMessage(timeoutMillis));
        }

        private Message track(Message msg) {
            if (msg != null) {
                if (++this.currentBatchRed == this.repullAt && this.keepGoing) {
                    this.sub.pull(this.batchSize);
                }
                if (this.currentBatchRed == this.batchSize) {
                    this.currentBatchRed = 0;
                }
            }
            return msg;
        }

        @Override
        public void stop() {
            this.keepGoing = false;
        }
    }
}

