/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.CompressionOption;
import io.nats.client.api.ConsumerLimits;
import io.nats.client.api.DiscardPolicy;
import io.nats.client.api.Mirror;
import io.nats.client.api.Placement;
import io.nats.client.api.Republish;
import io.nats.client.api.RetentionPolicy;
import io.nats.client.api.Source;
import io.nats.client.api.StorageType;
import io.nats.client.api.SubjectTransform;
import io.nats.client.support.JsonParseException;
import io.nats.client.support.JsonParser;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.Validator;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StreamConfiguration
implements JsonSerializable {
    private final String name;
    private final String description;
    private final List<String> subjects;
    private final RetentionPolicy retentionPolicy;
    private final CompressionOption compressionOption;
    private final long maxConsumers;
    private final long maxMsgs;
    private final long maxMsgsPerSubject;
    private final long maxBytes;
    private final Duration maxAge;
    private final int maxMsgSize;
    private final StorageType storageType;
    private final int replicas;
    private final boolean noAck;
    private final String templateOwner;
    private final DiscardPolicy discardPolicy;
    private final Duration duplicateWindow;
    private final Placement placement;
    private final Republish republish;
    private final SubjectTransform subjectTransform;
    private final ConsumerLimits consumerLimits;
    private final Mirror mirror;
    private final List<Source> sources;
    private final boolean sealed;
    private final boolean allowRollup;
    private final boolean allowDirect;
    private final boolean mirrorDirect;
    private final boolean denyDelete;
    private final boolean denyPurge;
    private final boolean discardNewPerSubject;
    private final Map<String, String> metadata;
    private final long firstSequence;

    static StreamConfiguration instance(JsonValue v) {
        Builder builder = new Builder();
        builder.retentionPolicy(RetentionPolicy.get(JsonValueUtils.readString(v, "retention")));
        builder.compressionOption(CompressionOption.get(JsonValueUtils.readString(v, "compression")));
        builder.storageType(StorageType.get(JsonValueUtils.readString(v, "storage")));
        builder.discardPolicy(DiscardPolicy.get(JsonValueUtils.readString(v, "discard")));
        builder.name(JsonValueUtils.readString(v, "name"));
        builder.description(JsonValueUtils.readString(v, "description"));
        builder.maxConsumers(JsonValueUtils.readLong(v, "max_consumers", -1L));
        builder.maxMessages(JsonValueUtils.readLong(v, "max_msgs", -1L));
        builder.maxMessagesPerSubject(JsonValueUtils.readLong(v, "max_msgs_per_subject", -1L));
        builder.maxBytes(JsonValueUtils.readLong(v, "max_bytes", -1L));
        builder.maxAge(JsonValueUtils.readNanos(v, "max_age"));
        builder.maximumMessageSize(JsonValueUtils.readInteger(v, "max_msg_size", -1));
        builder.replicas(JsonValueUtils.readInteger(v, "num_replicas", 1));
        builder.noAck(JsonValueUtils.readBoolean(v, "no_ack"));
        builder.templateOwner(JsonValueUtils.readString(v, "template_owner"));
        builder.duplicateWindow(JsonValueUtils.readNanos(v, "duplicate_window"));
        builder.subjects(JsonValueUtils.readStringList(v, "subjects"));
        builder.placement(Placement.optionalInstance(JsonValueUtils.readValue(v, "placement")));
        builder.republish(Republish.optionalInstance(JsonValueUtils.readValue(v, "republish")));
        builder.subjectTransform(SubjectTransform.optionalInstance(JsonValueUtils.readValue(v, "subject_transform")));
        builder.consumerLimits(ConsumerLimits.optionalInstance(JsonValueUtils.readValue(v, "consumer_limits")));
        builder.mirror(Mirror.optionalInstance(JsonValueUtils.readValue(v, "mirror")));
        builder.sources(Source.optionalListOf(JsonValueUtils.readValue(v, "sources")));
        builder.sealed(JsonValueUtils.readBoolean(v, "sealed"));
        builder.allowRollup(JsonValueUtils.readBoolean(v, "allow_rollup_hdrs"));
        builder.allowDirect(JsonValueUtils.readBoolean(v, "allow_direct"));
        builder.mirrorDirect(JsonValueUtils.readBoolean(v, "mirror_direct"));
        builder.denyDelete(JsonValueUtils.readBoolean(v, "deny_delete"));
        builder.denyPurge(JsonValueUtils.readBoolean(v, "deny_purge"));
        builder.discardNewPerSubject(JsonValueUtils.readBoolean(v, "discard_new_per_subject"));
        builder.metadata(JsonValueUtils.readStringStringMap(v, "metadata"));
        builder.firstSequence(JsonValueUtils.readLong(v, "first_seq", 1L));
        return builder.build();
    }

    StreamConfiguration(Builder b) {
        this.name = b.name;
        this.description = b.description;
        this.subjects = b.subjects;
        this.retentionPolicy = b.retentionPolicy;
        this.compressionOption = b.compressionOption;
        this.maxConsumers = b.maxConsumers;
        this.maxMsgs = b.maxMsgs;
        this.maxMsgsPerSubject = b.maxMsgsPerSubject;
        this.maxBytes = b.maxBytes;
        this.maxAge = b.maxAge;
        this.maxMsgSize = b.maxMsgSize;
        this.storageType = b.storageType;
        this.replicas = b.replicas;
        this.noAck = b.noAck;
        this.templateOwner = b.templateOwner;
        this.discardPolicy = b.discardPolicy;
        this.duplicateWindow = b.duplicateWindow;
        this.placement = b.placement;
        this.republish = b.republish;
        this.subjectTransform = b.subjectTransform;
        this.consumerLimits = b.consumerLimits;
        this.mirror = b.mirror;
        this.sources = b.sources;
        this.sealed = b.sealed;
        this.allowRollup = b.allowRollup;
        this.allowDirect = b.allowDirect;
        this.mirrorDirect = b.mirrorDirect;
        this.denyDelete = b.denyDelete;
        this.denyPurge = b.denyPurge;
        this.discardNewPerSubject = b.discardNewPerSubject;
        this.metadata = b.metadata;
        this.firstSequence = b.firstSequence;
    }

    public static StreamConfiguration instance(String json) throws JsonParseException {
        return StreamConfiguration.instance(JsonParser.parse(json));
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "name", this.name);
        JsonUtils.addField(sb, "description", this.description);
        JsonUtils.addStrings(sb, "subjects", this.subjects);
        JsonUtils.addField(sb, "retention", this.retentionPolicy.toString());
        JsonUtils.addEnumWhenNot(sb, "compression", this.compressionOption, CompressionOption.None);
        JsonUtils.addField(sb, "max_consumers", this.maxConsumers);
        JsonUtils.addField(sb, "max_msgs", this.maxMsgs);
        JsonUtils.addField(sb, "max_msgs_per_subject", this.maxMsgsPerSubject);
        JsonUtils.addField(sb, "max_bytes", this.maxBytes);
        JsonUtils.addFieldAsNanos(sb, "max_age", this.maxAge);
        JsonUtils.addField(sb, "max_msg_size", this.maxMsgSize);
        JsonUtils.addField(sb, "storage", this.storageType.toString());
        JsonUtils.addField(sb, "num_replicas", this.replicas);
        JsonUtils.addFldWhenTrue(sb, "no_ack", this.noAck);
        JsonUtils.addField(sb, "template_owner", this.templateOwner);
        JsonUtils.addField(sb, "discard", this.discardPolicy.toString());
        JsonUtils.addFieldAsNanos(sb, "duplicate_window", this.duplicateWindow);
        if (this.placement != null && this.placement.hasData()) {
            JsonUtils.addField(sb, "placement", this.placement);
        }
        JsonUtils.addField(sb, "republish", this.republish);
        JsonUtils.addField(sb, "subject_transform", this.subjectTransform);
        JsonUtils.addField(sb, "consumer_limits", this.consumerLimits);
        JsonUtils.addField(sb, "mirror", this.mirror);
        JsonUtils.addJsons(sb, "sources", this.sources);
        JsonUtils.addFldWhenTrue(sb, "sealed", this.sealed);
        JsonUtils.addFldWhenTrue(sb, "allow_rollup_hdrs", this.allowRollup);
        JsonUtils.addFldWhenTrue(sb, "allow_direct", this.allowDirect);
        JsonUtils.addFldWhenTrue(sb, "mirror_direct", this.mirrorDirect);
        JsonUtils.addFldWhenTrue(sb, "deny_delete", this.denyDelete);
        JsonUtils.addFldWhenTrue(sb, "deny_purge", this.denyPurge);
        JsonUtils.addFldWhenTrue(sb, "discard_new_per_subject", this.discardNewPerSubject);
        JsonUtils.addField(sb, "metadata", this.metadata);
        JsonUtils.addFieldWhenGreaterThan(sb, "first_seq", this.firstSequence, 1L);
        return JsonUtils.endJson(sb).toString();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public DiscardPolicy getDiscardPolicy() {
        return this.discardPolicy;
    }

    public RetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public CompressionOption getCompressionOption() {
        return this.compressionOption;
    }

    public long getMaxConsumers() {
        return this.maxConsumers;
    }

    public long getMaxMsgs() {
        return this.maxMsgs;
    }

    public long getMaxMsgsPerSubject() {
        return this.maxMsgsPerSubject;
    }

    public long getMaxBytes() {
        return this.maxBytes;
    }

    public Duration getMaxAge() {
        return this.maxAge;
    }

    @Deprecated
    public long getMaxMsgSize() {
        return this.maxMsgSize;
    }

    public int getMaximumMessageSize() {
        return this.maxMsgSize;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public boolean getNoAck() {
        return this.noAck;
    }

    public String getTemplateOwner() {
        return this.templateOwner;
    }

    public Duration getDuplicateWindow() {
        return this.duplicateWindow;
    }

    public Placement getPlacement() {
        return this.placement;
    }

    public Republish getRepublish() {
        return this.republish;
    }

    public SubjectTransform getSubjectTransform() {
        return this.subjectTransform;
    }

    public ConsumerLimits getConsumerLimits() {
        return this.consumerLimits;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public boolean getSealed() {
        return this.sealed;
    }

    public boolean getAllowRollup() {
        return this.allowRollup;
    }

    public boolean getAllowDirect() {
        return this.allowDirect;
    }

    public boolean getMirrorDirect() {
        return this.mirrorDirect;
    }

    public boolean getDenyDelete() {
        return this.denyDelete;
    }

    public boolean getDenyPurge() {
        return this.denyPurge;
    }

    public boolean isDiscardNewPerSubject() {
        return this.discardNewPerSubject;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public long getFirstSequence() {
        return this.firstSequence;
    }

    public String toString() {
        return this.toJson();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StreamConfiguration sc) {
        return new Builder(sc);
    }

    public static class Builder {
        private String name = null;
        private String description = null;
        private final List<String> subjects = new ArrayList<String>();
        private RetentionPolicy retentionPolicy = RetentionPolicy.Limits;
        private CompressionOption compressionOption = CompressionOption.None;
        private long maxConsumers = -1L;
        private long maxMsgs = -1L;
        private long maxMsgsPerSubject = -1L;
        private long maxBytes = -1L;
        private Duration maxAge = Duration.ZERO;
        private int maxMsgSize = -1;
        private StorageType storageType = StorageType.File;
        private int replicas = 1;
        private boolean noAck = false;
        private String templateOwner = null;
        private DiscardPolicy discardPolicy = DiscardPolicy.Old;
        private Duration duplicateWindow = Duration.ZERO;
        private Placement placement = null;
        private Republish republish = null;
        private SubjectTransform subjectTransform = null;
        private ConsumerLimits consumerLimits = null;
        private Mirror mirror = null;
        private final List<Source> sources = new ArrayList<Source>();
        private boolean sealed = false;
        private boolean allowRollup = false;
        private boolean allowDirect = false;
        private boolean mirrorDirect = false;
        private boolean denyDelete = false;
        private boolean denyPurge = false;
        private boolean discardNewPerSubject = false;
        private Map<String, String> metadata;
        private long firstSequence = 1L;

        public Builder() {
        }

        public Builder(StreamConfiguration sc) {
            if (sc != null) {
                this.name = sc.name;
                this.description = sc.description;
                this.subjects(sc.subjects);
                this.retentionPolicy = sc.retentionPolicy;
                this.compressionOption = sc.compressionOption;
                this.maxConsumers = sc.maxConsumers;
                this.maxMsgs = sc.maxMsgs;
                this.maxMsgsPerSubject = sc.maxMsgsPerSubject;
                this.maxBytes = sc.maxBytes;
                this.maxAge = sc.maxAge;
                this.maxMsgSize = sc.maxMsgSize;
                this.storageType = sc.storageType;
                this.replicas = sc.replicas;
                this.noAck = sc.noAck;
                this.templateOwner = sc.templateOwner;
                this.discardPolicy = sc.discardPolicy;
                this.duplicateWindow = sc.duplicateWindow;
                this.placement = sc.placement;
                this.republish = sc.republish;
                this.subjectTransform = sc.subjectTransform;
                this.consumerLimits = sc.consumerLimits;
                this.mirror = sc.mirror;
                this.sources(sc.sources);
                this.sealed = sc.sealed;
                this.allowRollup = sc.allowRollup;
                this.allowDirect = sc.allowDirect;
                this.mirrorDirect = sc.mirrorDirect;
                this.denyDelete = sc.denyDelete;
                this.denyPurge = sc.denyPurge;
                this.discardNewPerSubject = sc.discardNewPerSubject;
                if (sc.metadata != null) {
                    this.metadata = new HashMap<String, String>(sc.metadata);
                }
                this.firstSequence = sc.firstSequence;
            }
        }

        public Builder name(String name) {
            this.name = Validator.validateStreamName(name, false);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder subjects(String ... subjects) {
            this.subjects.clear();
            return this.addSubjects(subjects);
        }

        public Builder subjects(Collection<String> subjects) {
            this.subjects.clear();
            return this.addSubjects(subjects);
        }

        public Builder addSubjects(String ... subjects) {
            if (subjects != null) {
                return this.addSubjects(Arrays.asList(subjects));
            }
            return this;
        }

        public Builder addSubjects(Collection<String> subjects) {
            if (subjects != null) {
                for (String sub : subjects) {
                    if (sub == null || this.subjects.contains(sub)) continue;
                    this.subjects.add(sub);
                }
            }
            return this;
        }

        public Builder retentionPolicy(RetentionPolicy policy) {
            this.retentionPolicy = policy == null ? RetentionPolicy.Limits : policy;
            return this;
        }

        public Builder compressionOption(CompressionOption compressionOption) {
            this.compressionOption = compressionOption == null ? CompressionOption.None : compressionOption;
            return this;
        }

        public Builder maxConsumers(long maxConsumers) {
            this.maxConsumers = Validator.validateMaxConsumers(maxConsumers);
            return this;
        }

        public Builder maxMessages(long maxMsgs) {
            this.maxMsgs = Validator.validateMaxMessages(maxMsgs);
            return this;
        }

        public Builder maxMessagesPerSubject(long maxMsgsPerSubject) {
            this.maxMsgsPerSubject = Validator.validateMaxMessagesPerSubject(maxMsgsPerSubject);
            return this;
        }

        public Builder maxBytes(long maxBytes) {
            this.maxBytes = Validator.validateMaxBytes(maxBytes);
            return this;
        }

        public Builder maxAge(Duration maxAge) {
            this.maxAge = Validator.validateDurationNotRequiredGtOrEqZero(maxAge, Duration.ZERO);
            return this;
        }

        public Builder maxAge(long maxAgeMillis) {
            this.maxAge = Validator.validateDurationNotRequiredGtOrEqZero(maxAgeMillis);
            return this;
        }

        @Deprecated
        public Builder maxMsgSize(long maxMsgSize) {
            this.maxMsgSize = (int)Validator.validateMaxMessageSize(maxMsgSize);
            return this;
        }

        public Builder maximumMessageSize(int maxMsgSize) {
            this.maxMsgSize = (int)Validator.validateMaxMessageSize(maxMsgSize);
            return this;
        }

        public Builder storageType(StorageType storageType) {
            this.storageType = storageType == null ? StorageType.File : storageType;
            return this;
        }

        public Builder replicas(int replicas) {
            this.replicas = Validator.validateNumberOfReplicas(replicas);
            return this;
        }

        public Builder noAck(boolean noAck) {
            this.noAck = noAck;
            return this;
        }

        public Builder templateOwner(String templateOwner) {
            this.templateOwner = Validator.emptyAsNull(templateOwner);
            return this;
        }

        public Builder discardPolicy(DiscardPolicy policy) {
            this.discardPolicy = policy == null ? DiscardPolicy.Old : policy;
            return this;
        }

        public Builder duplicateWindow(Duration window) {
            this.duplicateWindow = Validator.validateDurationNotRequiredGtOrEqZero(window, Duration.ZERO);
            return this;
        }

        public Builder duplicateWindow(long windowMillis) {
            this.duplicateWindow = Validator.validateDurationNotRequiredGtOrEqZero(windowMillis);
            return this;
        }

        public Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public Builder republish(Republish republish) {
            this.republish = republish;
            return this;
        }

        public Builder subjectTransform(SubjectTransform subjectTransform) {
            this.subjectTransform = subjectTransform;
            return this;
        }

        public Builder consumerLimits(ConsumerLimits consumerLimits) {
            this.consumerLimits = consumerLimits;
            return this;
        }

        public Builder mirror(Mirror mirror) {
            this.mirror = mirror;
            return this;
        }

        public Builder sources(Source ... sources) {
            this.sources.clear();
            return this.addSources(sources);
        }

        public Builder sources(Collection<Source> sources) {
            this.sources.clear();
            return this.addSources(sources);
        }

        public Builder addSources(Source ... sources) {
            return this.addSources(Arrays.asList(sources));
        }

        public Builder addSources(Collection<Source> sources) {
            if (sources != null) {
                for (Source source : sources) {
                    if (source == null || this.sources.contains(source)) continue;
                    this.sources.add(source);
                }
            }
            return this;
        }

        public Builder addSource(Source source) {
            if (source != null && !this.sources.contains(source)) {
                this.sources.add(source);
            }
            return this;
        }

        protected Builder sealed(boolean sealed) {
            this.sealed = sealed;
            return this;
        }

        public Builder allowRollup(boolean allowRollup) {
            this.allowRollup = allowRollup;
            return this;
        }

        public Builder allowDirect(boolean allowDirect) {
            this.allowDirect = allowDirect;
            return this;
        }

        public Builder mirrorDirect(boolean mirrorDirect) {
            this.mirrorDirect = mirrorDirect;
            return this;
        }

        public Builder denyDelete(boolean denyDelete) {
            this.denyDelete = denyDelete;
            return this;
        }

        public Builder denyPurge(boolean denyPurge) {
            this.denyPurge = denyPurge;
            return this;
        }

        public Builder discardNewPerSubject(boolean discardNewPerSubject) {
            this.discardNewPerSubject = discardNewPerSubject;
            return this;
        }

        public Builder seal() {
            this.sealed = true;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder firstSequence(long firstSeq) {
            this.firstSequence = firstSeq > 1L ? firstSeq : 1L;
            return this;
        }

        public StreamConfiguration build() {
            return new StreamConfiguration(this);
        }
    }
}

