/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.DiscardPolicy;
import io.nats.client.api.FeatureConfiguration;
import io.nats.client.api.Mirror;
import io.nats.client.api.Placement;
import io.nats.client.api.Republish;
import io.nats.client.api.Source;
import io.nats.client.api.StorageType;
import io.nats.client.api.StreamConfiguration;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.NatsKeyValueUtil;
import io.nats.client.support.Validator;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class KeyValueConfiguration
extends FeatureConfiguration {
    KeyValueConfiguration(StreamConfiguration sc) {
        super(sc, NatsKeyValueUtil.extractBucketName(sc.getName()));
    }

    public long getMaxHistoryPerKey() {
        return this.sc.getMaxMsgsPerSubject();
    }

    public long getMaxValueSize() {
        return this.sc.getMaxMsgSize();
    }

    public Republish getRepublish() {
        return this.sc.getRepublish();
    }

    public Mirror getMirror() {
        return this.sc.getMirror();
    }

    public List<Source> getSources() {
        return this.sc.getSources();
    }

    public String toString() {
        return "KeyValueConfiguration" + this.toJson();
    }

    @Override
    public JsonValue toJsonValue() {
        JsonValueUtils.MapBuilder mb = new JsonValueUtils.MapBuilder(super.toJsonValue());
        mb.jv.mapOrder.remove("metaData");
        mb.put("maxHistoryPerKey", this.getMaxHistoryPerKey());
        mb.put("maxValueSize", this.getMaxValueSize());
        mb.put("republish", this.getRepublish());
        mb.put("mirror", this.getMirror());
        mb.put("sources", this.getSources());
        mb.jv.mapOrder.add("metaData");
        return mb.toJsonValue();
    }

    public static Builder builder() {
        return new Builder((KeyValueConfiguration)null);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static Builder builder(KeyValueConfiguration kvc) {
        return new Builder(kvc);
    }

    public static class Builder
    extends FeatureConfiguration.Builder<Builder, KeyValueConfiguration> {
        Mirror mirror;
        final List<Source> sources = new ArrayList<Source>();

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder() {
            this((KeyValueConfiguration)null);
        }

        public Builder(String name) {
            this((KeyValueConfiguration)null);
            this.name(name);
        }

        public Builder(KeyValueConfiguration kvc) {
            if (kvc == null) {
                this.scBuilder = new StreamConfiguration.Builder();
                this.maxHistoryPerKey(1);
                this.replicas(1);
            } else {
                this.scBuilder = new StreamConfiguration.Builder(kvc.sc);
                this.name = NatsKeyValueUtil.extractBucketName(kvc.sc.getName());
            }
        }

        @Override
        public Builder name(String name) {
            return (Builder)super.name(name);
        }

        @Override
        public Builder description(String description) {
            return (Builder)super.description(description);
        }

        public Builder maxHistoryPerKey(int maxHistoryPerKey) {
            this.scBuilder.maxMessagesPerSubject(Validator.validateMaxHistory(maxHistoryPerKey));
            return this;
        }

        @Override
        public Builder maxBucketSize(long maxBucketSize) {
            return (Builder)super.maxBucketSize(maxBucketSize);
        }

        public Builder maxValueSize(long maxValueSize) {
            this.scBuilder.maxMsgSize(Validator.validateMaxValueSize(maxValueSize));
            return this;
        }

        @Override
        public Builder ttl(Duration ttl) {
            return (Builder)super.ttl(ttl);
        }

        @Override
        public Builder storageType(StorageType storageType) {
            return (Builder)super.storageType(storageType);
        }

        @Override
        public Builder replicas(int replicas) {
            return (Builder)super.replicas(replicas);
        }

        @Override
        public Builder placement(Placement placement) {
            return (Builder)super.placement(placement);
        }

        @Override
        public Builder compression(boolean compression) {
            return (Builder)super.compression(compression);
        }

        @Override
        public Builder metadata(Map<String, String> metadata) {
            return (Builder)super.metadata(metadata);
        }

        public Builder republish(Republish republish) {
            this.scBuilder.republish(republish);
            return this;
        }

        public Builder mirror(Mirror mirror) {
            this.mirror = mirror;
            return this;
        }

        public Builder sources(Source ... sources) {
            this.sources.clear();
            return this.addSources(sources);
        }

        public Builder sources(Collection<Source> sources) {
            this.sources.clear();
            return this.addSources(sources);
        }

        public Builder addSource(Source source) {
            if (source != null && !this.sources.contains(source)) {
                this.sources.add(source);
            }
            return this;
        }

        public Builder addSources(Source ... sources) {
            if (sources != null) {
                return this.addSources(Arrays.asList(sources));
            }
            return this;
        }

        public Builder addSources(Collection<Source> sources) {
            if (sources != null) {
                for (Source source : sources) {
                    if (source == null || this.sources.contains(source)) continue;
                    this.sources.add(source);
                }
            }
            return this;
        }

        @Override
        public KeyValueConfiguration build() {
            this.name = Validator.required(this.name, "name");
            this.scBuilder.name(NatsKeyValueUtil.toStreamName(this.name)).allowRollup(true).allowDirect(true).discardPolicy(DiscardPolicy.New).denyDelete(true);
            if (this.mirror != null) {
                this.scBuilder.mirrorDirect(true);
                String name = this.mirror.getName();
                if (NatsKeyValueUtil.hasPrefix(name)) {
                    this.scBuilder.mirror(this.mirror);
                } else {
                    this.scBuilder.mirror(((Mirror.Builder)Mirror.builder(this.mirror).name(NatsKeyValueUtil.toStreamName(name))).build());
                }
            } else if (!this.sources.isEmpty()) {
                for (Source source : this.sources) {
                    String name = source.getName();
                    if (NatsKeyValueUtil.hasPrefix(name)) {
                        this.scBuilder.addSource(source);
                        continue;
                    }
                    this.scBuilder.addSource(((Source.Builder)Source.builder(source).name(NatsKeyValueUtil.toStreamName(name))).build());
                }
            } else {
                this.scBuilder.subjects(NatsKeyValueUtil.toStreamSubject(this.name));
            }
            return new KeyValueConfiguration(this.scBuilder.build());
        }
    }
}

