/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

public class WebsocketFrameHeader {
    public static int MAX_FRAME_HEADER_SIZE = 14;
    private byte byte0;
    private boolean mask;
    private long payloadLength;
    private int maskingKey;
    private int maskingKeyOffset = 0;

    public WebsocketFrameHeader withOp(OpCode op, boolean isFinal) {
        this.byte0 = (byte)(op.getCode() | (isFinal ? 128 : 0));
        return this;
    }

    public WebsocketFrameHeader withNoMask() {
        this.mask = false;
        return this;
    }

    public WebsocketFrameHeader withMask(int maskingKey) {
        this.mask = true;
        this.maskingKey = maskingKey;
        this.maskingKeyOffset = 0;
        return this;
    }

    public WebsocketFrameHeader withPayloadLength(long payloadLength) {
        this.payloadLength = payloadLength;
        return this;
    }

    public boolean isFinal() {
        return (this.byte0 & 0x80) != 0;
    }

    public boolean isMasked() {
        return this.mask;
    }

    public int getMaskingKey() {
        return this.maskingKey;
    }

    public long getPayloadLength() {
        return this.payloadLength;
    }

    public OpCode getOpCode() {
        return OpCode.of(this.byte0 & 0xF);
    }

    public boolean isPayloadEmpty() {
        return 0L == this.payloadLength;
    }

    public int filterPayload(byte[] buffer, int offset, int length) {
        length = Math.min(length, this.payloadLength > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.payloadLength);
        this.payloadLength -= (long)length;
        if (this.mask) {
            for (int i = 0; i < length; ++i) {
                int key = 0xFF & this.maskingKey >> 8 * (7 - this.maskingKeyOffset);
                int n = offset + i;
                buffer[n] = (byte)(buffer[n] ^ key);
                this.maskingKeyOffset = (this.maskingKeyOffset + 1) % 8;
            }
        }
        return length;
    }

    public int size() {
        int size = 2;
        if (this.payloadLength > 65535L) {
            size += 8;
        } else if (this.payloadLength > 125L) {
            size += 2;
        }
        if (this.mask) {
            size += 4;
        }
        return size;
    }

    public static int size(byte[] buffer, int offset) {
        int size = 2;
        if (0 != (buffer[offset + 1] & 0x80)) {
            size += 4;
        }
        switch (buffer[offset + 1] & 0x7F) {
            case 126: {
                size += 2;
                break;
            }
            case 127: {
                size += 8;
            }
        }
        return size;
    }

    public int read(byte[] buffer, int offset, int length) {
        if (length < this.size()) {
            return 0;
        }
        int startOffset = offset;
        buffer[offset++] = this.byte0;
        if (this.payloadLength > 65535L) {
            buffer[offset++] = (byte)(0x7F | (this.mask ? 128 : 0));
            buffer[offset++] = (byte)(this.payloadLength >> 56 & 0xFFL);
            buffer[offset++] = (byte)(this.payloadLength >> 48 & 0xFFL);
            buffer[offset++] = (byte)(this.payloadLength >> 40 & 0xFFL);
            buffer[offset++] = (byte)(this.payloadLength >> 32 & 0xFFL);
            buffer[offset++] = (byte)(this.payloadLength >> 24 & 0xFFL);
            buffer[offset++] = (byte)(this.payloadLength >> 16 & 0xFFL);
            buffer[offset++] = (byte)(this.payloadLength >> 8 & 0xFFL);
            buffer[offset++] = (byte)(this.payloadLength & 0xFFL);
        } else if (this.payloadLength > 125L) {
            buffer[offset++] = (byte)(0x7E | (this.mask ? 128 : 0));
            buffer[offset++] = (byte)(this.payloadLength >> 8);
            buffer[offset++] = (byte)(this.payloadLength & 0xFFL);
        } else {
            buffer[offset++] = (byte)(this.payloadLength | (long)(this.mask ? 128 : 0));
        }
        if (this.mask) {
            buffer[offset++] = (byte)(this.maskingKey >> 24 & 0xFF);
            buffer[offset++] = (byte)(this.maskingKey >> 16 & 0xFF);
            buffer[offset++] = (byte)(this.maskingKey >> 8 & 0xFF);
            buffer[offset++] = (byte)(this.maskingKey & 0xFF);
        }
        return offset - startOffset;
    }

    public int write(byte[] buffer, int offset, int length) {
        int i;
        if (length < 2) {
            return 0;
        }
        int size = WebsocketFrameHeader.size(buffer, offset);
        if (size > length) {
            return 0;
        }
        this.byte0 = buffer[offset++];
        this.mask = 0 != (buffer[offset] & 0x80);
        this.payloadLength = buffer[offset] & 0x7F;
        ++offset;
        if (126L == this.payloadLength) {
            this.payloadLength = 0L;
            for (i = 0; i < 2; ++i) {
                this.payloadLength <<= 8;
                this.payloadLength |= (long)(buffer[offset++] & 0xFF);
            }
        } else if (127L == this.payloadLength) {
            this.payloadLength = 0L;
            for (i = 0; i < 8; ++i) {
                this.payloadLength <<= 8;
                this.payloadLength |= (long)(buffer[offset++] & 0xFF);
            }
        }
        if (this.mask) {
            this.maskingKey = 0;
            this.maskingKeyOffset = 0;
            for (i = 0; i < 4; ++i) {
                this.maskingKey <<= 8;
                this.maskingKey |= buffer[offset++] & 0xFF;
            }
        }
        return size;
    }

    public static enum OpCode {
        CONTINUATION(0),
        TEXT(1),
        BINARY(2),
        CLOSE(8),
        PING(9),
        PONG(10),
        UNKNOWN(16);

        private int code;

        private OpCode(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static OpCode of(int code) {
            switch (code) {
                case 0: {
                    return CONTINUATION;
                }
                case 1: {
                    return TEXT;
                }
                case 2: {
                    return BINARY;
                }
                case 8: {
                    return CLOSE;
                }
                case 9: {
                    return PING;
                }
                case 10: {
                    return PONG;
                }
            }
            return UNKNOWN;
        }
    }
}

