/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.BuilderBase;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ByteArrayPrimitiveBuilder
extends BuilderBase {
    private byte[] buffer;
    private int position;

    public ByteArrayPrimitiveBuilder(int initialSize, int allocationSizeSuggestion, Charset defaultCharset) {
        super(defaultCharset, allocationSizeSuggestion);
        this.buffer = new byte[ByteArrayPrimitiveBuilder.bufferAllocSize(initialSize, this.allocationSize)];
        this.position = 0;
    }

    public ByteArrayPrimitiveBuilder() {
        this(-1, 32, StandardCharsets.US_ASCII);
    }

    public ByteArrayPrimitiveBuilder(int initialSize) {
        this(initialSize, 32, StandardCharsets.US_ASCII);
    }

    public ByteArrayPrimitiveBuilder(Charset defaultCharset) {
        this(-1, -1, defaultCharset);
    }

    public ByteArrayPrimitiveBuilder(int initialSize, Charset defaultCharset) {
        this(initialSize, -1, defaultCharset);
    }

    public ByteArrayPrimitiveBuilder(byte[] bytes) {
        this(bytes, bytes.length);
    }

    public ByteArrayPrimitiveBuilder(byte[] bytes, int len) {
        super(StandardCharsets.US_ASCII, 32);
        this.position = len;
        this.buffer = new byte[ByteArrayPrimitiveBuilder.bufferAllocSize(len, this.allocationSize)];
        System.arraycopy(bytes, 0, this.buffer, 0, len);
    }

    @Override
    public int length() {
        return this.position;
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    @Override
    public boolean equals(byte[] bytes) {
        if (bytes == null || this.position != bytes.length) {
            return false;
        }
        for (int x = 0; x < bytes.length; ++x) {
            if (this.buffer[x] == bytes[x]) continue;
            return false;
        }
        return true;
    }

    public int copyTo(byte[] dest, int destPos) {
        System.arraycopy(this.buffer, 0, dest, destPos, this.position);
        return this.position;
    }

    public void copyTo(OutputStream out) throws IOException {
        out.write(this.buffer, 0, this.position);
    }

    @Override
    public byte[] toByteArray() {
        byte[] bytes = new byte[this.position];
        System.arraycopy(this.buffer, 0, bytes, 0, this.position);
        return bytes;
    }

    @Override
    public byte[] internalArray() {
        return this.buffer;
    }

    public void ensureCapacity(int bytesNeeded) {
        int bytesAvailable = this.buffer.length - this.position;
        if (bytesAvailable < bytesNeeded) {
            byte[] newBuffer = new byte[ByteArrayPrimitiveBuilder.bufferAllocSize(this.position + bytesNeeded, this.allocationSize)];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.position);
            this.buffer = newBuffer;
        }
    }

    public ByteArrayPrimitiveBuilder clear() {
        this.position = 0;
        return this;
    }

    public void setAllocationSize(int allocationSizeSuggestion) {
        this._setAllocationSize(allocationSizeSuggestion);
    }

    public ByteArrayPrimitiveBuilder append(int i) {
        this.append(Integer.toString(i).getBytes(StandardCharsets.US_ASCII));
        return this;
    }

    public ByteArrayPrimitiveBuilder append(String src) {
        return this.append(src, this.defaultCharset);
    }

    public ByteArrayPrimitiveBuilder append(String src, Charset charset) {
        return src == null ? this.append(NULL, 0, 4) : this.append(src.getBytes(charset));
    }

    public ByteArrayPrimitiveBuilder append(CharBuffer src) {
        return this.append(src, this.defaultCharset);
    }

    public ByteArrayPrimitiveBuilder append(CharBuffer src, Charset charset) {
        if (src == null) {
            this.append(NULL, 0, 4);
        } else {
            this.append(src.toString().getBytes(charset));
        }
        return this;
    }

    public ByteArrayPrimitiveBuilder append(byte b) {
        this.ensureCapacity(1);
        this.buffer[this.position++] = b;
        return this;
    }

    public ByteArrayPrimitiveBuilder append(byte[] src) {
        return this.append(src, 0, src.length);
    }

    public ByteArrayPrimitiveBuilder append(byte[] src, int len) {
        if (len > 0) {
            this.ensureCapacity(len);
            System.arraycopy(src, 0, this.buffer, this.position, len);
            this.position += len;
        }
        return this;
    }

    public ByteArrayPrimitiveBuilder append(byte[] src, int index, int len) {
        if (len > 0) {
            this.ensureCapacity(len);
            System.arraycopy(src, index, this.buffer, this.position, len);
            this.position += len;
        }
        return this;
    }

    public ByteArrayPrimitiveBuilder append(ByteArrayPrimitiveBuilder bab) {
        if (bab != null) {
            this.append(bab.buffer, bab.length());
        }
        return this;
    }

    @Override
    public int appendUnchecked(byte b) {
        this.buffer[this.position++] = b;
        return 1;
    }

    @Override
    public int appendUnchecked(byte[] src) {
        return this.appendUnchecked(src, 0, src.length);
    }

    @Override
    public int appendUnchecked(byte[] src, int srcPos, int len) {
        System.arraycopy(src, srcPos, this.buffer, this.position, len);
        this.position += len;
        return len;
    }

    public String toString() {
        return new String(this.buffer, 0, this.position, this.defaultCharset);
    }
}

