/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.KeyValue;
import io.nats.client.KeyValueOptions;
import io.nats.client.Message;
import io.nats.client.PurgeOptions;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.api.KeyValueEntry;
import io.nats.client.api.KeyValueOperation;
import io.nats.client.api.KeyValuePurgeOptions;
import io.nats.client.api.KeyValueStatus;
import io.nats.client.api.KeyValueWatchOption;
import io.nats.client.api.KeyValueWatcher;
import io.nats.client.api.MessageInfo;
import io.nats.client.api.Mirror;
import io.nats.client.api.PublishAck;
import io.nats.client.api.StreamInfo;
import io.nats.client.impl.Headers;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsFeatureBase;
import io.nats.client.impl.NatsKeyValueWatchSubscription;
import io.nats.client.impl.NatsMessage;
import io.nats.client.support.DateTimeUtils;
import io.nats.client.support.NatsKeyValueUtil;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;

public class NatsKeyValue
extends NatsFeatureBase
implements KeyValue {
    private final String bucketName;
    private final String streamSubject;
    private final String readPrefix;
    private final String writePrefix;

    NatsKeyValue(NatsConnection connection, String bucketName, KeyValueOptions kvo) throws IOException {
        super(connection, kvo);
        String writeTemp;
        StreamInfo si;
        this.bucketName = Validator.validateBucketName(bucketName, true);
        this.streamName = NatsKeyValueUtil.toStreamName(bucketName);
        try {
            si = this.jsm.getStreamInfo(this.streamName);
        }
        catch (JetStreamApiException e) {
            throw new IOException(e);
        }
        this.streamSubject = NatsKeyValueUtil.toStreamSubject(bucketName);
        String readTemp = NatsKeyValueUtil.toKeyPrefix(bucketName);
        Mirror m = si.getConfiguration().getMirror();
        if (m != null) {
            String mExtApi;
            String bName = NatsKeyValueUtil.trimPrefix(m.getName());
            String string = mExtApi = m.getExternal() == null ? null : m.getExternal().getApi();
            if (mExtApi == null) {
                writeTemp = NatsKeyValueUtil.toKeyPrefix(bName);
            } else {
                readTemp = NatsKeyValueUtil.toKeyPrefix(bName);
                writeTemp = mExtApi + "." + NatsKeyValueUtil.toKeyPrefix(bName);
            }
        } else {
            writeTemp = kvo == null || kvo.getJetStreamOptions().isDefaultPrefix() ? readTemp : kvo.getJetStreamOptions().getPrefix() + readTemp;
        }
        this.readPrefix = readTemp;
        this.writePrefix = writeTemp;
    }

    String readSubject(String key) {
        return this.readPrefix + key;
    }

    String writeSubject(String key) {
        return this.writePrefix + key;
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    @Override
    public KeyValueEntry get(String key) throws IOException, JetStreamApiException {
        return this.existingOnly(this._get(Validator.validateNonWildcardKvKeyRequired(key)));
    }

    @Override
    public KeyValueEntry get(String key, long revision) throws IOException, JetStreamApiException {
        return this.existingOnly(this._get(Validator.validateNonWildcardKvKeyRequired(key), revision));
    }

    KeyValueEntry existingOnly(KeyValueEntry kve) {
        return kve == null || kve.getOperation() != KeyValueOperation.PUT ? null : kve;
    }

    KeyValueEntry _get(String key) throws IOException, JetStreamApiException {
        MessageInfo mi = this._getLast(this.readSubject(key));
        return mi == null ? null : new KeyValueEntry(mi);
    }

    KeyValueEntry _get(String key, long revision) throws IOException, JetStreamApiException {
        KeyValueEntry kve;
        MessageInfo mi = this._getBySeq(revision);
        if (mi != null && key.equals((kve = new KeyValueEntry(mi)).getKey())) {
            return kve;
        }
        return null;
    }

    @Override
    public long put(String key, byte[] value) throws IOException, JetStreamApiException {
        return this._write(key, value, null).getSeqno();
    }

    @Override
    public long put(String key, String value) throws IOException, JetStreamApiException {
        return this._write(key, value.getBytes(StandardCharsets.UTF_8), null).getSeqno();
    }

    @Override
    public long put(String key, Number value) throws IOException, JetStreamApiException {
        return this.put(key, value.toString().getBytes(StandardCharsets.US_ASCII));
    }

    @Override
    public long create(String key, byte[] value) throws IOException, JetStreamApiException {
        Validator.validateNonWildcardKvKeyRequired(key);
        try {
            return this.update(key, value, 0L);
        }
        catch (JetStreamApiException e) {
            KeyValueEntry kve;
            if (e.getApiErrorCode() == 10071 && (kve = this._get(key)) != null && kve.getOperation() != KeyValueOperation.PUT) {
                return this.update(key, value, kve.getRevision());
            }
            throw e;
        }
    }

    @Override
    public long update(String key, byte[] value, long expectedRevision) throws IOException, JetStreamApiException {
        Validator.validateNonWildcardKvKeyRequired(key);
        Headers h = new Headers().add("Nats-Expected-Last-Subject-Sequence", Long.toString(expectedRevision));
        return this._write(key, value, h).getSeqno();
    }

    @Override
    public long update(String key, String value, long expectedRevision) throws IOException, JetStreamApiException {
        return this.update(key, value.getBytes(StandardCharsets.UTF_8), expectedRevision);
    }

    @Override
    public void delete(String key) throws IOException, JetStreamApiException {
        Validator.validateNonWildcardKvKeyRequired(key);
        this._write(key, null, NatsKeyValueUtil.getDeleteHeaders());
    }

    @Override
    public void delete(String key, long expectedRevision) throws IOException, JetStreamApiException {
        Validator.validateNonWildcardKvKeyRequired(key);
        Headers h = NatsKeyValueUtil.getDeleteHeaders().put("Nats-Expected-Last-Subject-Sequence", Long.toString(expectedRevision));
        this._write(key, null, h).getSeqno();
    }

    @Override
    public void purge(String key) throws IOException, JetStreamApiException {
        this._write(key, null, NatsKeyValueUtil.getPurgeHeaders());
    }

    @Override
    public void purge(String key, long expectedRevision) throws IOException, JetStreamApiException {
        Headers h = NatsKeyValueUtil.getPurgeHeaders().put("Nats-Expected-Last-Subject-Sequence", Long.toString(expectedRevision));
        this._write(key, null, h);
    }

    private PublishAck _write(String key, byte[] data, Headers h) throws IOException, JetStreamApiException {
        Validator.validateNonWildcardKvKeyRequired(key);
        return this.js.publish(NatsMessage.builder().subject(this.writeSubject(key)).data(data).headers(h).build());
    }

    @Override
    public NatsKeyValueWatchSubscription watch(String key, KeyValueWatcher watcher, KeyValueWatchOption ... watchOptions) throws IOException, JetStreamApiException, InterruptedException {
        Validator.validateKvKeyWildcardAllowedRequired(key);
        Validator.validateNotNull(watcher, "Watcher is required");
        return new NatsKeyValueWatchSubscription(this, key, watcher, -1L, watchOptions);
    }

    @Override
    public NatsKeyValueWatchSubscription watch(String key, KeyValueWatcher watcher, long fromRevision, KeyValueWatchOption ... watchOptions) throws IOException, JetStreamApiException, InterruptedException {
        Validator.validateKvKeyWildcardAllowedRequired(key);
        Validator.validateNotNull(watcher, "Watcher is required");
        return new NatsKeyValueWatchSubscription(this, key, watcher, fromRevision, watchOptions);
    }

    @Override
    public NatsKeyValueWatchSubscription watchAll(KeyValueWatcher watcher, KeyValueWatchOption ... watchOptions) throws IOException, JetStreamApiException, InterruptedException {
        Validator.validateNotNull(watcher, "Watcher is required");
        return new NatsKeyValueWatchSubscription(this, ">", watcher, -1L, watchOptions);
    }

    @Override
    public NatsKeyValueWatchSubscription watchAll(KeyValueWatcher watcher, long fromRevision, KeyValueWatchOption ... watchOptions) throws IOException, JetStreamApiException, InterruptedException {
        Validator.validateNotNull(watcher, "Watcher is required");
        return new NatsKeyValueWatchSubscription(this, ">", watcher, fromRevision, watchOptions);
    }

    @Override
    public List<String> keys() throws IOException, JetStreamApiException, InterruptedException {
        ArrayList<String> list = new ArrayList<String>();
        this.visitSubject(this.readSubject(">"), DeliverPolicy.LastPerSubject, true, false, m -> {
            KeyValueOperation op = NatsKeyValueUtil.getOperation(m.getHeaders());
            if (op == KeyValueOperation.PUT) {
                list.add(new NatsKeyValueUtil.BucketAndKey((Message)m).key);
            }
        });
        return list;
    }

    @Override
    public List<KeyValueEntry> history(String key) throws IOException, JetStreamApiException, InterruptedException {
        Validator.validateNonWildcardKvKeyRequired(key);
        ArrayList<KeyValueEntry> list = new ArrayList<KeyValueEntry>();
        this.visitSubject(this.readSubject(key), DeliverPolicy.All, false, true, m -> list.add(new KeyValueEntry(m)));
        return list;
    }

    @Override
    public void purgeDeletes() throws IOException, JetStreamApiException, InterruptedException {
        this.purgeDeletes(null);
    }

    @Override
    public void purgeDeletes(KeyValuePurgeOptions options) throws IOException, JetStreamApiException, InterruptedException {
        long dmThresh;
        long l = dmThresh = options == null ? KeyValuePurgeOptions.DEFAULT_THRESHOLD_MILLIS : options.getDeleteMarkersThresholdMillis();
        ZonedDateTime limit = dmThresh < 0L ? DateTimeUtils.fromNow(600000L) : (dmThresh == 0L ? DateTimeUtils.fromNow(KeyValuePurgeOptions.DEFAULT_THRESHOLD_MILLIS) : DateTimeUtils.fromNow(-dmThresh));
        ArrayList keep0List = new ArrayList();
        ArrayList keep1List = new ArrayList();
        this.visitSubject(this.streamSubject, DeliverPolicy.LastPerSubject, true, false, m -> {
            KeyValueEntry kve = new KeyValueEntry(m);
            if (kve.getOperation() != KeyValueOperation.PUT) {
                if (kve.getCreated().isAfter(limit)) {
                    keep1List.add(new NatsKeyValueUtil.BucketAndKey((Message)m).key);
                } else {
                    keep0List.add(new NatsKeyValueUtil.BucketAndKey((Message)m).key);
                }
            }
        });
        for (String key : keep0List) {
            this.jsm.purgeStream(this.streamName, PurgeOptions.subject(this.readSubject(key)));
        }
        for (String key : keep1List) {
            PurgeOptions po = PurgeOptions.builder().subject(this.readSubject(key)).keep(1L).build();
            this.jsm.purgeStream(this.streamName, po);
        }
    }

    @Override
    public KeyValueStatus getStatus() throws IOException, JetStreamApiException, InterruptedException {
        return new KeyValueStatus(this.jsm.getStreamInfo(this.streamName));
    }
}

