/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.ConsumerContext;
import io.nats.client.Dispatcher;
import io.nats.client.JetStream;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamOptions;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import io.nats.client.PublishOptions;
import io.nats.client.PullSubscribeOptions;
import io.nats.client.PushSubscribeOptions;
import io.nats.client.StreamContext;
import io.nats.client.SubscribeOptions;
import io.nats.client.api.AckPolicy;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.api.PublishAck;
import io.nats.client.api.StreamInfo;
import io.nats.client.impl.Headers;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsJetStreamImpl;
import io.nats.client.impl.NatsJetStreamPullSubscription;
import io.nats.client.impl.NatsJetStreamSubscription;
import io.nats.client.impl.NatsStreamContext;
import io.nats.client.impl.NatsSubscription;
import io.nats.client.impl.NatsSubscriptionFactory;
import io.nats.client.impl.OrderedMessageManager;
import io.nats.client.impl.PullMessageManager;
import io.nats.client.impl.PullOrderedMessageManager;
import io.nats.client.impl.PushMessageManager;
import io.nats.client.support.NatsJetStreamClientError;
import io.nats.client.support.NatsRequestCompletableFuture;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class NatsJetStream
extends NatsJetStreamImpl
implements JetStream {
    MessageManagerFactory _pushMessageManagerFactory = PushMessageManager::new;
    MessageManagerFactory _pushOrderedMessageManagerFactory = OrderedMessageManager::new;
    MessageManagerFactory _pullMessageManagerFactory = (mmConn, mmJs, mmStream, mmSo, mmCc, mmQueueMode, mmSyncMode) -> new PullMessageManager(mmConn, mmSo, mmSyncMode);
    MessageManagerFactory _pullOrderedMessageManagerFactory = (mmConn, mmJs, mmStream, mmSo, mmCc, mmQueueMode, mmSyncMode) -> new PullOrderedMessageManager(mmConn, mmJs, mmStream, mmSo, mmCc, mmSyncMode);

    public NatsJetStream(NatsConnection connection, JetStreamOptions jsOptions) throws IOException {
        super(connection, jsOptions);
    }

    NatsJetStream(NatsJetStreamImpl impl) {
        super(impl);
    }

    @Override
    public PublishAck publish(String subject, byte[] body) throws IOException, JetStreamApiException {
        return this.publishSyncInternal(subject, null, body, null);
    }

    @Override
    public PublishAck publish(String subject, Headers headers, byte[] body) throws IOException, JetStreamApiException {
        return this.publishSyncInternal(subject, headers, body, null);
    }

    @Override
    public PublishAck publish(String subject, byte[] body, PublishOptions options) throws IOException, JetStreamApiException {
        return this.publishSyncInternal(subject, null, body, options);
    }

    @Override
    public PublishAck publish(String subject, Headers headers, byte[] body, PublishOptions options) throws IOException, JetStreamApiException {
        return this.publishSyncInternal(subject, headers, body, options);
    }

    @Override
    public PublishAck publish(Message message) throws IOException, JetStreamApiException {
        Validator.validateNotNull(message, "Message");
        return this.publishSyncInternal(message.getSubject(), message.getHeaders(), message.getData(), null);
    }

    @Override
    public PublishAck publish(Message message, PublishOptions options) throws IOException, JetStreamApiException {
        Validator.validateNotNull(message, "Message");
        return this.publishSyncInternal(message.getSubject(), message.getHeaders(), message.getData(), options);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(String subject, byte[] body) {
        return this.publishAsyncInternal(subject, null, body, null, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(String subject, Headers headers, byte[] body) {
        return this.publishAsyncInternal(subject, headers, body, null, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(String subject, byte[] body, PublishOptions options) {
        return this.publishAsyncInternal(subject, null, body, options, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(String subject, Headers headers, byte[] body, PublishOptions options) {
        return this.publishAsyncInternal(subject, headers, body, options, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(Message message) {
        Validator.validateNotNull(message, "Message");
        return this.publishAsyncInternal(message.getSubject(), message.getHeaders(), message.getData(), null, null);
    }

    @Override
    public CompletableFuture<PublishAck> publishAsync(Message message, PublishOptions options) {
        Validator.validateNotNull(message, "Message");
        return this.publishAsyncInternal(message.getSubject(), message.getHeaders(), message.getData(), options, null);
    }

    private PublishAck publishSyncInternal(String subject, Headers headers, byte[] data, PublishOptions options) throws IOException, JetStreamApiException {
        Headers merged = this.mergePublishOptions(headers, options);
        if (this.jso.isPublishNoAck()) {
            this.conn.publishInternal(subject, null, merged, data);
            return null;
        }
        Duration timeout = options == null ? this.jso.getRequestTimeout() : options.getStreamTimeout();
        Message resp = this.makeInternalRequestResponseRequired(subject, merged, data, timeout, NatsRequestCompletableFuture.CancelAction.COMPLETE);
        return this.processPublishResponse(resp, options);
    }

    private CompletableFuture<PublishAck> publishAsyncInternal(String subject, Headers headers, byte[] data, PublishOptions options, Duration knownTimeout) {
        Headers merged = this.mergePublishOptions(headers, options);
        if (this.jso.isPublishNoAck()) {
            this.conn.publishInternal(subject, null, merged, data);
            return null;
        }
        CompletableFuture<Message> future = this.conn.requestFutureInternal(subject, merged, data, knownTimeout, NatsRequestCompletableFuture.CancelAction.COMPLETE);
        return future.thenCompose(resp -> {
            try {
                this.responseRequired((Message)resp);
                return CompletableFuture.completedFuture(this.processPublishResponse((Message)resp, options));
            }
            catch (JetStreamApiException | IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private PublishAck processPublishResponse(Message resp, PublishOptions options) throws IOException, JetStreamApiException {
        String pubStream;
        if (resp.isStatusMessage()) {
            throw new IOException("Error Publishing: " + resp.getStatus().getMessageWithCode());
        }
        PublishAck ack = new PublishAck(resp);
        String ackStream = ack.getStream();
        String string = pubStream = options == null ? null : options.getStream();
        if (pubStream != null && !pubStream.equals(ackStream)) {
            throw new IOException("Expected ack from stream " + pubStream + ", received from: " + ackStream);
        }
        return ack;
    }

    private Headers mergePublishOptions(Headers headers, PublishOptions opts) {
        Headers merged;
        Headers headers2 = merged = headers == null ? null : new Headers(headers);
        if (opts != null) {
            merged = this.mergeNum(merged, "Nats-Expected-Last-Sequence", opts.getExpectedLastSequence());
            merged = this.mergeNum(merged, "Nats-Expected-Last-Subject-Sequence", opts.getExpectedLastSubjectSequence());
            merged = this.mergeString(merged, "Nats-Expected-Last-Msg-Id", opts.getExpectedLastMsgId());
            merged = this.mergeString(merged, "Nats-Expected-Stream", opts.getExpectedStream());
            merged = this.mergeString(merged, "Nats-Msg-Id", opts.getMessageId());
        }
        return merged;
    }

    private Headers mergeNum(Headers h, String key, long value) {
        return value > -1L ? this._mergeNum(h, key, Long.toString(value)) : h;
    }

    private Headers mergeString(Headers h, String key, String value) {
        return Validator.nullOrEmpty(value) ? h : this._mergeNum(h, key, value);
    }

    private Headers _mergeNum(Headers h, String key, String value) {
        if (h == null) {
            h = new Headers();
        }
        return h.add(key, value);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    JetStreamSubscription createSubscription(String userSubscribeSubject, PushSubscribeOptions pushSubscribeOptions, PullSubscribeOptions pullSubscribeOptions, String queueName, NatsDispatcher dispatcher, MessageHandler userHandler, boolean isAutoAck, PullMessageManager pmmInstance) throws IOException, JetStreamApiException {
        NatsJetStreamSubscription sub;
        NatsSubscriptionFactory subFactory;
        MessageManagerFactory mmFactory;
        String settledConsumerName;
        ConsumerConfiguration settledCC;
        String settledStream;
        ConsumerConfiguration userCC;
        String stream;
        SubscribeOptions so;
        boolean isPullMode = pullSubscribeOptions != null;
        String settledDeliverGroup = null;
        if (isPullMode) {
            so = pullSubscribeOptions;
            stream = pullSubscribeOptions.getStream();
            userCC = so.getConsumerConfiguration();
            Validator.validateNotSupplied(userCC.getDeliverGroup(), NatsJetStreamClientError.JsSubPullCantHaveDeliverGroup);
            Validator.validateNotSupplied(userCC.getDeliverSubject(), NatsJetStreamClientError.JsSubPullCantHaveDeliverSubject);
        } else {
            so = pushSubscribeOptions == null ? PushSubscribeOptions.DEFAULT_PUSH_OPTS : pushSubscribeOptions;
            stream = so.getStream();
            userCC = so.getConsumerConfiguration();
            if (userCC.maxPullWaitingWasSet()) {
                throw NatsJetStreamClientError.JsSubPushCantHaveMaxPullWaiting.instance();
            }
            if (userCC.maxBatchWasSet()) {
                throw NatsJetStreamClientError.JsSubPushCantHaveMaxBatch.instance();
            }
            if (userCC.maxBytesWasSet()) {
                throw NatsJetStreamClientError.JsSubPushCantHaveMaxBytes.instance();
            }
            settledDeliverGroup = Validator.validateMustMatchIfBothSupplied(userCC.getDeliverGroup(), queueName, NatsJetStreamClientError.JsSubQueueDeliverGroupMismatch);
            if (so.isOrdered() && settledDeliverGroup != null) {
                throw NatsJetStreamClientError.JsSubOrderedNotAllowOnQueues.instance();
            }
            if (dispatcher != null && (so.getPendingMessageLimit() != 524288L || so.getPendingByteLimit() != 0x4000000L)) {
                throw NatsJetStreamClientError.JsSubPushAsyncCantSetPending.instance();
            }
        }
        if (userCC.getIdleHeartbeat() != null && userCC.getIdleHeartbeat().toMillis() > 0L) {
            if (isPullMode) {
                throw NatsJetStreamClientError.JsSubFcHbNotValidPull.instance();
            }
            if (settledDeliverGroup != null) {
                throw NatsJetStreamClientError.JsSubFcHbNotValidQueue.instance();
            }
        }
        userSubscribeSubject = Validator.emptyAsNull(userSubscribeSubject);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (userCC.getFilterSubjects() == null) {
            if (userSubscribeSubject != null) {
                arrayList.add(userSubscribeSubject);
            }
        } else {
            arrayList.addAll(userCC.getFilterSubjects());
            if (userSubscribeSubject != null && !arrayList.contains(userSubscribeSubject)) {
                throw NatsJetStreamClientError.JsSubSubjectDoesNotMatchFilter.instance();
            }
        }
        if (stream == null) {
            if (arrayList.isEmpty()) {
                throw NatsJetStreamClientError.JsSubSubjectNeededToLookupStream.instance();
            }
            settledStream = this.lookupStreamBySubject((String)arrayList.get(0));
            if (settledStream == null) {
                throw NatsJetStreamClientError.JsSubNoMatchingStreamForSubject.instance();
            }
        } else {
            settledStream = stream;
        }
        ConsumerConfiguration serverCC = null;
        String consumerName = userCC.getDurable();
        if (consumerName == null) {
            consumerName = userCC.getName();
        }
        String inboxDeliver = userCC.getDeliverSubject();
        if (!so.isFastBind() && consumerName != null) {
            ConsumerInfo serverInfo = this.lookupConsumerInfo(settledStream, consumerName);
            if (serverInfo != null) {
                ConsumerConfigurationComparer userCCC = new ConsumerConfigurationComparer(userCC);
                serverCC = serverInfo.getConsumerConfiguration();
                List<String> changes = userCCC.getChanges(serverCC);
                if (!changes.isEmpty()) {
                    throw NatsJetStreamClientError.JsSubExistingConsumerCannotBeModified.instance("Changed fields: " + changes);
                }
                if (isPullMode) {
                    if (!Validator.nullOrEmpty(serverCC.getDeliverSubject())) {
                        throw NatsJetStreamClientError.JsSubConsumerAlreadyConfiguredAsPush.instance();
                    }
                } else if (Validator.nullOrEmpty(serverCC.getDeliverSubject())) {
                    throw NatsJetStreamClientError.JsSubConsumerAlreadyConfiguredAsPull.instance();
                }
                if (serverCC.getDeliverGroup() == null) {
                    if (settledDeliverGroup != null) throw NatsJetStreamClientError.JsSubExistingConsumerNotQueue.instance();
                    if (serverInfo.isPushBound()) {
                        throw NatsJetStreamClientError.JsSubConsumerAlreadyBound.instance();
                    }
                } else {
                    if (settledDeliverGroup == null) {
                        throw NatsJetStreamClientError.JsSubExistingConsumerIsQueue.instance();
                    }
                    if (!serverCC.getDeliverGroup().equals(settledDeliverGroup)) {
                        throw NatsJetStreamClientError.JsSubExistingQueueDoesNotMatchRequestedQueue.instance();
                    }
                }
                if (arrayList.isEmpty()) {
                    if (serverCC.getFilterSubjects() != null) {
                        List<String> list = serverCC.getFilterSubjects();
                    }
                } else if (!Validator.consumerFilterSubjectsAreEquivalent(arrayList, serverCC.getFilterSubjects())) {
                    throw NatsJetStreamClientError.JsSubSubjectDoesNotMatchFilter.instance();
                }
                inboxDeliver = serverCC.getDeliverSubject();
            } else if (so.isBind()) {
                throw NatsJetStreamClientError.JsSubConsumerNotFoundRequiredInBind.instance();
            }
        }
        String settledInboxDeliver = isPullMode ? this.conn.createInbox() + ".*" : (inboxDeliver == null ? this.conn.createInbox() : inboxDeliver);
        if (so.isFastBind() || serverCC != null) {
            settledCC = serverCC;
            settledConsumerName = so.getName();
        } else {
            void var14_16;
            ConsumerConfiguration.Builder builder = ConsumerConfiguration.builder(userCC);
            if (!isPullMode) {
                builder.deliverSubject(settledInboxDeliver);
            }
            builder.filterSubjects((List<String>)var14_16);
            builder.deliverGroup(settledDeliverGroup);
            settledCC = builder.build();
            settledConsumerName = null;
        }
        if (isPullMode) {
            void var22_27;
            if (pmmInstance == null) {
                mmFactory = so.isOrdered() ? this._pullOrderedMessageManagerFactory : this._pullMessageManagerFactory;
                MessageManager messageManager = mmFactory.createMessageManager(this.conn, this, settledStream, so, settledCC, false, dispatcher == null);
            } else {
                PullMessageManager pullMessageManager = pmmInstance;
            }
            subFactory = (arg_0, arg_1, arg_2, arg_3, arg_4) -> this.lambda$createSubscription$3(settledStream, settledConsumerName, (MessageManager)var22_27, arg_0, arg_1, arg_2, arg_3, arg_4);
        } else {
            mmFactory = so.isOrdered() ? this._pushOrderedMessageManagerFactory : this._pushMessageManagerFactory;
            MessageManager messageManager = mmFactory.createMessageManager(this.conn, this, settledStream, so, settledCC, settledDeliverGroup != null, dispatcher == null);
            subFactory = (sid, lSubject, lQgroup, lConn, lDispatcher) -> {
                NatsJetStreamSubscription nsub = new NatsJetStreamSubscription(sid, lSubject, lQgroup, lConn, lDispatcher, this, settledStream, settledConsumerName, messageManager);
                if (lDispatcher == null) {
                    nsub.setPendingLimits(so.getPendingMessageLimit(), so.getPendingByteLimit());
                }
                return nsub;
            };
        }
        if (dispatcher == null) {
            sub = (NatsJetStreamSubscription)this.conn.createSubscription(settledInboxDeliver, settledDeliverGroup, null, subFactory);
        } else {
            void var22_29;
            AsyncMessageHandler handler = new AsyncMessageHandler((MessageManager)var22_29, userHandler, isAutoAck, settledCC);
            sub = (NatsJetStreamSubscription)dispatcher.subscribeImplJetStream(settledInboxDeliver, settledDeliverGroup, handler, subFactory);
        }
        if (settledConsumerName != null) return sub;
        this._createConsumerUnsubscribeOnException(settledStream, settledCC, sub);
        return sub;
    }

    private String lookupStreamSubject(String stream) throws IOException, JetStreamApiException {
        StreamInfo si = this._getStreamInfo(stream, null);
        List<String> streamSubjects = si.getConfiguration().getSubjects();
        return streamSubjects.size() == 1 ? streamSubjects.get(0) : null;
    }

    @Override
    public JetStreamSubscription subscribe(String subscribeSubject) throws IOException, JetStreamApiException {
        subscribeSubject = Validator.validateSubject(subscribeSubject, true);
        return this.createSubscription(subscribeSubject, null, null, null, null, null, false, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subscribeSubject, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        subscribeSubject = Validator.validateSubject(subscribeSubject, false);
        return this.createSubscription(subscribeSubject, options, null, null, null, null, false, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subscribeSubject, String queue, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        subscribeSubject = Validator.validateSubject(subscribeSubject, false);
        Validator.validateQueueName(queue, false);
        return this.createSubscription(subscribeSubject, options, null, queue, null, null, false, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subscribeSubject, Dispatcher dispatcher, MessageHandler handler, boolean autoAck) throws IOException, JetStreamApiException {
        subscribeSubject = Validator.validateSubject(subscribeSubject, false);
        Validator.validateNotNull(dispatcher, "Dispatcher");
        Validator.validateNotNull(handler, "Handler");
        return this.createSubscription(subscribeSubject, null, null, null, (NatsDispatcher)dispatcher, handler, autoAck, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subscribeSubject, Dispatcher dispatcher, MessageHandler handler, boolean autoAck, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        subscribeSubject = Validator.validateSubject(subscribeSubject, false);
        Validator.validateNotNull(dispatcher, "Dispatcher");
        Validator.validateNotNull(handler, "Handler");
        return this.createSubscription(subscribeSubject, options, null, null, (NatsDispatcher)dispatcher, handler, autoAck, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subscribeSubject, String queue, Dispatcher dispatcher, MessageHandler handler, boolean autoAck, PushSubscribeOptions options) throws IOException, JetStreamApiException {
        subscribeSubject = Validator.validateSubject(subscribeSubject, false);
        Validator.validateQueueName(queue, false);
        Validator.validateNotNull(dispatcher, "Dispatcher");
        Validator.validateNotNull(handler, "Handler");
        return this.createSubscription(subscribeSubject, options, null, queue, (NatsDispatcher)dispatcher, handler, autoAck, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subscribeSubject, PullSubscribeOptions options) throws IOException, JetStreamApiException {
        subscribeSubject = Validator.validateSubject(subscribeSubject, false);
        Validator.validateNotNull(options, "Pull Subscribe Options");
        return this.createSubscription(subscribeSubject, null, options, null, null, null, false, null);
    }

    @Override
    public JetStreamSubscription subscribe(String subscribeSubject, Dispatcher dispatcher, MessageHandler handler, PullSubscribeOptions options) throws IOException, JetStreamApiException {
        subscribeSubject = Validator.validateSubject(subscribeSubject, false);
        Validator.validateNotNull(dispatcher, "Dispatcher");
        Validator.validateNotNull(handler, "Handler");
        Validator.validateNotNull(options, "Pull Subscribe Options");
        return this.createSubscription(subscribeSubject, null, options, null, (NatsDispatcher)dispatcher, handler, false, null);
    }

    @Override
    public StreamContext getStreamContext(String streamName) throws IOException, JetStreamApiException {
        Validator.validateStreamName(streamName, true);
        return this.getNatsStreamContext(streamName);
    }

    @Override
    public ConsumerContext getConsumerContext(String streamName, String consumerName) throws IOException, JetStreamApiException {
        Validator.validateStreamName(streamName, true);
        Validator.required(consumerName, "Consumer Name");
        return this.getNatsStreamContext(streamName).getConsumerContext(consumerName);
    }

    private NatsStreamContext getNatsStreamContext(String streamName) throws IOException, JetStreamApiException {
        return new NatsStreamContext(streamName, this, this.conn, this.jso);
    }

    private /* synthetic */ NatsSubscription lambda$createSubscription$3(String settledStream, String settledConsumerName, MessageManager mm, String sid, String lSubject, String lQgroup, NatsConnection lConn, NatsDispatcher lDispatcher) {
        return new NatsJetStreamPullSubscription(sid, lSubject, lConn, lDispatcher, this, settledStream, settledConsumerName, mm);
    }

    static class AsyncMessageHandler
    implements MessageHandler {
        MessageManager manager;
        MessageHandler userHandler;
        boolean autoAck;

        public AsyncMessageHandler(MessageManager manager, MessageHandler userHandler, boolean isAutoAck, ConsumerConfiguration settledServerCC) {
            this.manager = manager;
            this.userHandler = userHandler;
            this.autoAck = isAutoAck && settledServerCC.getAckPolicy() != AckPolicy.None;
        }

        @Override
        public void onMessage(Message msg) throws InterruptedException {
            if (this.manager.manage(msg) == MessageManager.ManageResult.MESSAGE) {
                this.userHandler.onMessage(msg);
                if (this.autoAck) {
                    msg.ack();
                }
            }
        }
    }

    static class ConsumerConfigurationComparer
    extends ConsumerConfiguration {
        public ConsumerConfigurationComparer(ConsumerConfiguration cc) {
            super(cc);
        }

        public List<String> getChanges(ConsumerConfiguration serverCc) {
            ConsumerConfigurationComparer serverCcc = new ConsumerConfigurationComparer(serverCc);
            ArrayList<String> changes = new ArrayList<String>();
            if (this.deliverPolicy != null && this.deliverPolicy != serverCcc.getDeliverPolicy()) {
                changes.add("deliverPolicy");
            }
            if (this.ackPolicy != null && this.ackPolicy != serverCcc.getAckPolicy()) {
                changes.add("ackPolicy");
            }
            if (this.replayPolicy != null && this.replayPolicy != serverCcc.getReplayPolicy()) {
                changes.add("replayPolicy");
            }
            if (this.flowControl != null && this.flowControl.booleanValue() != serverCcc.isFlowControl()) {
                changes.add("flowControl");
            }
            if (this.headersOnly != null && this.headersOnly.booleanValue() != serverCcc.isHeadersOnly()) {
                changes.add("headersOnly");
            }
            if (this.memStorage != null && this.memStorage.booleanValue() != serverCcc.isMemStorage()) {
                changes.add("memStorage");
            }
            if (this.startSeq != null && !this.startSeq.equals(serverCcc.getStartSequence())) {
                changes.add("startSequence");
            }
            if (this.rateLimit != null && !this.rateLimit.equals(serverCcc.getRateLimit())) {
                changes.add("rateLimit");
            }
            if (this.maxDeliver != null && (long)this.maxDeliver.intValue() != serverCcc.getMaxDeliver()) {
                changes.add("maxDeliver");
            }
            if (this.maxAckPending != null && (long)this.maxAckPending.intValue() != serverCcc.getMaxAckPending()) {
                changes.add("maxAckPending");
            }
            if (this.maxPullWaiting != null && (long)this.maxPullWaiting.intValue() != serverCcc.getMaxPullWaiting()) {
                changes.add("maxPullWaiting");
            }
            if (this.maxBatch != null && (long)this.maxBatch.intValue() != serverCcc.getMaxBatch()) {
                changes.add("maxBatch");
            }
            if (this.maxBytes != null && (long)this.maxBytes.intValue() != serverCcc.getMaxBytes()) {
                changes.add("maxBytes");
            }
            if (this.numReplicas != null && !this.numReplicas.equals(serverCcc.numReplicas)) {
                changes.add("numReplicas");
            }
            if (this.pauseUntil != null && !this.pauseUntil.equals(serverCcc.pauseUntil)) {
                changes.add("pauseUntil");
            }
            if (this.ackWait != null && !this.ackWait.equals(ConsumerConfigurationComparer.getOrUnset(serverCcc.ackWait))) {
                changes.add("ackWait");
            }
            if (this.idleHeartbeat != null && !this.idleHeartbeat.equals(ConsumerConfigurationComparer.getOrUnset(serverCcc.idleHeartbeat))) {
                changes.add("idleHeartbeat");
            }
            if (this.maxExpires != null && !this.maxExpires.equals(ConsumerConfigurationComparer.getOrUnset(serverCcc.maxExpires))) {
                changes.add("maxExpires");
            }
            if (this.inactiveThreshold != null && !this.inactiveThreshold.equals(ConsumerConfigurationComparer.getOrUnset(serverCcc.inactiveThreshold))) {
                changes.add("inactiveThreshold");
            }
            if (this.startTime != null && !this.startTime.equals(serverCcc.startTime)) {
                changes.add("startTime");
            }
            if (this.description != null && !this.description.equals(serverCcc.description)) {
                changes.add("description");
            }
            if (this.sampleFrequency != null && !this.sampleFrequency.equals(serverCcc.sampleFrequency)) {
                changes.add("sampleFrequency");
            }
            if (this.deliverSubject != null && !this.deliverSubject.equals(serverCcc.deliverSubject)) {
                changes.add("deliverSubject");
            }
            if (this.deliverGroup != null && !this.deliverGroup.equals(serverCcc.deliverGroup)) {
                changes.add("deliverGroup");
            }
            if (this.backoff != null && !Validator.consumerFilterSubjectsAreEquivalent(this.backoff, serverCcc.backoff)) {
                changes.add("backoff");
            }
            if (this.metadata != null && !Validator.mapsAreEquivalent(this.metadata, serverCcc.metadata)) {
                changes.add("metadata");
            }
            if (this.filterSubjects != null && !Validator.consumerFilterSubjectsAreEquivalent(this.filterSubjects, serverCcc.filterSubjects)) {
                changes.add("filterSubjects");
            }
            return changes;
        }
    }

    static interface MessageManagerFactory {
        public MessageManager createMessageManager(NatsConnection var1, NatsJetStream var2, String var3, SubscribeOptions var4, ConsumerConfiguration var5, boolean var6, boolean var7);
    }
}

