/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Options;
import io.nats.client.ServerPool;
import io.nats.client.impl.ServerPoolEntry;
import io.nats.client.support.NatsUri;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class NatsServerPool
implements ServerPool {
    private final Object listLock = new Object();
    private List<ServerPoolEntry> entryList;
    private Options options;
    private int maxConnectAttempts;
    private NatsUri lastConnected;
    private boolean hasSecureServer;
    private String defaultScheme;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(Options opts) {
        this.options = opts;
        this.maxConnectAttempts = this.options.getMaxReconnect() < 0 ? Integer.MAX_VALUE : this.options.getMaxReconnect() + 1;
        Object object = this.listLock;
        synchronized (object) {
            this.entryList = new ArrayList<ServerPoolEntry>();
            for (NatsUri nuri : this.options.getNatsServerUris()) {
                boolean notAlreadyInList = true;
                for (ServerPoolEntry entry : this.entryList) {
                    if (!nuri.equivalent(entry.nuri)) continue;
                    notAlreadyInList = false;
                    break;
                }
                if (!notAlreadyInList) continue;
                if (this.defaultScheme == null && !nuri.getScheme().equals("nats")) {
                    this.defaultScheme = nuri.getScheme();
                }
                this.entryList.add(new ServerPoolEntry(nuri, false));
            }
            this.afterListChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptDiscoveredUrls(List<String> discoveredServers) {
        if (this.options.isIgnoreDiscoveredServers()) {
            return false;
        }
        Object object = this.listLock;
        synchronized (object) {
            boolean bl;
            ArrayList<NatsUri> discovered = new ArrayList<NatsUri>();
            for (String string : discoveredServers) {
                try {
                    discovered.add(new NatsUri(string, this.defaultScheme));
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            ArrayList<ServerPoolEntry> newEntryList = new ArrayList<ServerPoolEntry>();
            for (ServerPoolEntry entry : this.entryList) {
                int ix = this.findEquivalent(discovered, entry.nuri);
                if (ix == -1 && !entry.nuri.equals(this.lastConnected) && entry.isGossiped) continue;
                newEntryList.add(entry);
                if (ix == -1) continue;
                discovered.remove(ix);
            }
            boolean bl2 = false;
            if (discovered.size() > 0) {
                bl = true;
                for (NatsUri d : discovered) {
                    newEntryList.add(new ServerPoolEntry(d, true));
                }
            }
            this.entryList = newEntryList;
            this.afterListChanged();
            return bl;
        }
    }

    private void afterListChanged() {
        if (this.entryList.size() > 1 && !this.options.isNoRandomize()) {
            Collections.shuffle(this.entryList, ThreadLocalRandom.current());
        }
        this.hasSecureServer = false;
        int lastConnectedIx = -1;
        for (int ix = 0; ix < this.entryList.size(); ++ix) {
            NatsUri nuri = this.entryList.get((int)ix).nuri;
            this.hasSecureServer |= nuri.isSecure();
            if (!nuri.equals(this.lastConnected)) continue;
            lastConnectedIx = ix;
        }
        if (lastConnectedIx != -1) {
            this.entryList.add(this.entryList.remove(lastConnectedIx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NatsUri peekNextServer() {
        Object object = this.listLock;
        synchronized (object) {
            return this.entryList.size() > 0 ? this.entryList.get((int)0).nuri : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NatsUri nextServer() {
        Object object = this.listLock;
        synchronized (object) {
            if (this.entryList.size() > 0) {
                ServerPoolEntry entry = this.entryList.remove(0);
                entry.lastAttempt = System.currentTimeMillis();
                this.entryList.add(entry);
                return entry.nuri;
            }
            return null;
        }
    }

    @Override
    public List<String> resolveHostToIps(String host) {
        if (this.options.isNoResolveHostnames()) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        try {
            InetAddress[] addresses;
            for (InetAddress a : addresses = InetAddress.getAllByName(host)) {
                results.add(a.getHostAddress());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (results.size() == 0) {
            return null;
        }
        if (results.size() > 1 && !this.options.isNoRandomize()) {
            Collections.shuffle(results, ThreadLocalRandom.current());
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectSucceeded(NatsUri nuri) {
        Object object = this.listLock;
        synchronized (object) {
            for (int x = this.entryList.size() - 1; x >= 0; --x) {
                ServerPoolEntry entry = this.entryList.get(x);
                if (!entry.nuri.equals(nuri)) continue;
                this.lastConnected = nuri;
                entry.failedAttempts = 0;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectFailed(NatsUri nuri) {
        Object object = this.listLock;
        synchronized (object) {
            for (int x = this.entryList.size() - 1; x >= 0; --x) {
                ServerPoolEntry entry = this.entryList.get(x);
                if (!entry.nuri.equals(nuri)) continue;
                if (++entry.failedAttempts >= this.maxConnectAttempts) {
                    this.entryList.remove(x);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getServerList() {
        Object object = this.listLock;
        synchronized (object) {
            ArrayList<String> list = new ArrayList<String>();
            for (ServerPoolEntry entry : this.entryList) {
                list.add(entry.nuri.toString());
            }
            return list;
        }
    }

    @Override
    public boolean hasSecureServer() {
        return this.hasSecureServer;
    }

    private int findEquivalent(List<NatsUri> list, NatsUri toFind) {
        for (int i = 0; i < list.size(); ++i) {
            NatsUri nuri = list.get(i);
            if (!nuri.equivalent(toFind)) continue;
            return i;
        }
        return -1;
    }
}

