/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.NKey;
import io.nats.client.support.Encoding;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.time.Duration;
import java.util.List;

public abstract class JwtUtils {
    private static final String ENCODED_CLAIM_HEADER = Encoding.toBase64Url("{\"typ\":\"JWT\", \"alg\":\"ed25519-nkey\"}");
    private static final long NO_LIMIT = -1L;
    public static final String NATS_USER_JWT_FORMAT = "-----BEGIN NATS USER JWT-----\n%s\n------END NATS USER JWT------\n\n************************* IMPORTANT *************************\nNKEY Seed printed below can be used to sign and prove identity.\nNKEYs are sensitive and should be treated as secrets.\n\n-----BEGIN USER NKEY SEED-----\n%s\n------END USER NKEY SEED------\n\n*************************************************************\n";

    private JwtUtils() {
    }

    public static long currentTimeSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String issueUserJWT(NKey signingKey, String accountId, String publicUserKey) throws GeneralSecurityException, IOException {
        return JwtUtils.issueUserJWT(signingKey, publicUserKey, null, null, JwtUtils.currentTimeSeconds(), null, new UserClaim(accountId));
    }

    public static String issueUserJWT(NKey signingKey, String accountId, String publicUserKey, String name) throws GeneralSecurityException, IOException {
        return JwtUtils.issueUserJWT(signingKey, publicUserKey, name, null, JwtUtils.currentTimeSeconds(), null, new UserClaim(accountId));
    }

    public static String issueUserJWT(NKey signingKey, String accountId, String publicUserKey, String name, Duration expiration, String ... tags) throws GeneralSecurityException, IOException {
        return JwtUtils.issueUserJWT(signingKey, publicUserKey, name, expiration, JwtUtils.currentTimeSeconds(), null, new UserClaim(accountId).tags(tags));
    }

    public static String issueUserJWT(NKey signingKey, String accountId, String publicUserKey, String name, Duration expiration, String[] tags, long issuedAt) throws GeneralSecurityException, IOException {
        return JwtUtils.issueUserJWT(signingKey, publicUserKey, name, expiration, issuedAt, null, new UserClaim(accountId).tags(tags));
    }

    public static String issueUserJWT(NKey signingKey, String accountId, String publicUserKey, String name, Duration expiration, String[] tags, long issuedAt, String audience) throws GeneralSecurityException, IOException {
        return JwtUtils.issueUserJWT(signingKey, publicUserKey, name, expiration, issuedAt, audience, new UserClaim(accountId).tags(tags));
    }

    public static String issueUserJWT(NKey signingKey, String publicUserKey, String name, Duration expiration, long issuedAt, UserClaim nats) throws GeneralSecurityException, IOException {
        return JwtUtils.issueUserJWT(signingKey, publicUserKey, name, expiration, issuedAt, null, nats);
    }

    public static String issueUserJWT(NKey signingKey, String publicUserKey, String name, Duration expiration, long issuedAt, String audience, UserClaim nats) throws GeneralSecurityException, IOException {
        if (signingKey.getType() != NKey.Type.ACCOUNT) {
            throw new IllegalArgumentException("issueUserJWT requires an account key for the signingKey parameter, but got " + (Object)((Object)signingKey.getType()));
        }
        NKey accountKey = NKey.fromPublicKey(nats.issuerAccount.toCharArray());
        if (accountKey.getType() != NKey.Type.ACCOUNT) {
            throw new IllegalArgumentException("issueUserJWT requires an account key for the accountId parameter, but got " + (Object)((Object)accountKey.getType()));
        }
        NKey userKey = NKey.fromPublicKey(publicUserKey.toCharArray());
        if (userKey.getType() != NKey.Type.USER) {
            throw new IllegalArgumentException("issueUserJWT requires a user key for the publicUserKey parameter, but got " + (Object)((Object)userKey.getType()));
        }
        String accSigningKeyPub = new String(signingKey.getPublicKey());
        String claimName = Validator.nullOrEmpty(name) ? publicUserKey : name;
        return JwtUtils.issueJWT(signingKey, publicUserKey, claimName, expiration, issuedAt, accSigningKeyPub, audience, nats);
    }

    public static String issueJWT(NKey signingKey, String publicUserKey, String name, Duration expiration, long issuedAt, String accSigningKeyPub, JsonSerializable nats) throws GeneralSecurityException, IOException {
        return JwtUtils.issueJWT(signingKey, publicUserKey, name, expiration, issuedAt, accSigningKeyPub, null, nats);
    }

    public static String issueJWT(NKey signingKey, String publicUserKey, String name, Duration expiration, long issuedAt, String accSigningKeyPub, String audience, JsonSerializable nats) throws GeneralSecurityException, IOException {
        Claim claim = new Claim();
        claim.aud = audience;
        claim.iat = issuedAt;
        claim.iss = accSigningKeyPub;
        claim.name = name;
        claim.sub = publicUserKey;
        claim.exp = expiration;
        claim.nats = nats;
        String claimJson = claim.toJson();
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] encoded = sha256.digest(claimJson.getBytes(StandardCharsets.US_ASCII));
        claim.jti = new String(Encoding.base32Encode(encoded));
        claimJson = claim.toJson();
        String encBody = Encoding.toBase64Url(claimJson);
        byte[] sig = (ENCODED_CLAIM_HEADER + "." + encBody).getBytes(StandardCharsets.UTF_8);
        String encSig = Encoding.toBase64Url(signingKey.sign(sig));
        return ENCODED_CLAIM_HEADER + "." + encBody + "." + encSig;
    }

    public static String getClaimBody(String jwt) {
        return Encoding.fromBase64Url(jwt.split("\\.")[1]);
    }

    static class Claim
    implements JsonSerializable {
        String aud;
        String jti;
        long iat;
        String iss;
        String name;
        String sub;
        Duration exp;
        JsonSerializable nats;

        Claim() {
        }

        @Override
        public String toJson() {
            StringBuilder sb = JsonUtils.beginJson();
            JsonUtils.addField(sb, "aud", this.aud);
            JsonUtils.addFieldEvenEmpty(sb, "jti", this.jti);
            JsonUtils.addField(sb, "iat", this.iat);
            JsonUtils.addField(sb, "iss", this.iss);
            JsonUtils.addField(sb, "name", this.name);
            JsonUtils.addField(sb, "sub", this.sub);
            if (this.exp != null && !this.exp.isZero() && !this.exp.isNegative()) {
                long seconds = this.exp.toMillis() / 1000L;
                JsonUtils.addField(sb, "exp", this.iat + seconds);
            }
            JsonUtils.addField(sb, "nats", this.nats);
            return JsonUtils.endJson(sb).toString();
        }
    }

    public static class Permission
    implements JsonSerializable {
        public String[] allow;
        public String[] deny;

        public Permission allow(String ... allow) {
            this.allow = allow;
            return this;
        }

        public Permission deny(String ... deny) {
            this.deny = deny;
            return this;
        }

        @Override
        public String toJson() {
            StringBuilder sb = JsonUtils.beginJson();
            JsonUtils.addStrings(sb, "allow", this.allow);
            JsonUtils.addStrings(sb, "deny", this.deny);
            return JsonUtils.endJson(sb).toString();
        }
    }

    public static class ResponsePermission
    implements JsonSerializable {
        public int maxMsgs;
        public Duration expires;

        public ResponsePermission maxMsgs(int maxMsgs) {
            this.maxMsgs = maxMsgs;
            return this;
        }

        public ResponsePermission expires(Duration expires) {
            this.expires = expires;
            return this;
        }

        public ResponsePermission expires(long expiresMillis) {
            this.expires = Duration.ofMillis(expiresMillis);
            return this;
        }

        @Override
        public String toJson() {
            StringBuilder sb = JsonUtils.beginJson();
            JsonUtils.addField(sb, "max", this.maxMsgs);
            JsonUtils.addFieldAsNanos(sb, "ttl", this.expires);
            return JsonUtils.endJson(sb).toString();
        }
    }

    public static class TimeRange
    implements JsonSerializable {
        public String start;
        public String end;

        public TimeRange(String start, String end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public String toJson() {
            StringBuilder sb = JsonUtils.beginJson();
            JsonUtils.addField(sb, "start", this.start);
            JsonUtils.addField(sb, "end", this.end);
            return JsonUtils.endJson(sb).toString();
        }
    }

    public static class UserClaim
    implements JsonSerializable {
        public String issuerAccount;
        public String[] tags;
        public String type = "user";
        public int version = 2;
        public Permission pub;
        public Permission sub;
        public ResponsePermission resp;
        public String[] src;
        public List<TimeRange> times;
        public String locale;
        public long subs = -1L;
        public long data = -1L;
        public long payload = -1L;
        public boolean bearerToken;
        public String[] allowedConnectionTypes;

        public UserClaim(String issuerAccount) {
            this.issuerAccount = issuerAccount;
        }

        @Override
        public String toJson() {
            StringBuilder sb = JsonUtils.beginJson();
            JsonUtils.addField(sb, "issuer_account", this.issuerAccount);
            JsonUtils.addStrings(sb, "tags", this.tags);
            JsonUtils.addField(sb, "type", this.type);
            JsonUtils.addField(sb, "version", this.version);
            JsonUtils.addField(sb, "pub", this.pub);
            JsonUtils.addField(sb, "sub", this.sub);
            JsonUtils.addField(sb, "resp", this.resp);
            JsonUtils.addStrings(sb, "src", this.src);
            JsonUtils.addJsons(sb, "times", this.times);
            JsonUtils.addField(sb, "times_location", this.locale);
            JsonUtils.addFieldWhenGteMinusOne(sb, "subs", this.subs);
            JsonUtils.addFieldWhenGteMinusOne(sb, "data", this.data);
            JsonUtils.addFieldWhenGteMinusOne(sb, "payload", this.payload);
            JsonUtils.addFldWhenTrue(sb, "bearer_token", this.bearerToken);
            JsonUtils.addStrings(sb, "allowed_connection_types", this.allowedConnectionTypes);
            return JsonUtils.endJson(sb).toString();
        }

        public UserClaim tags(String ... tags) {
            this.tags = tags;
            return this;
        }

        public UserClaim pub(Permission pub) {
            this.pub = pub;
            return this;
        }

        public UserClaim sub(Permission sub) {
            this.sub = sub;
            return this;
        }

        public UserClaim resp(ResponsePermission resp) {
            this.resp = resp;
            return this;
        }

        public UserClaim src(String ... src) {
            this.src = src;
            return this;
        }

        public UserClaim times(List<TimeRange> times) {
            this.times = times;
            return this;
        }

        public UserClaim locale(String locale) {
            this.locale = locale;
            return this;
        }

        public UserClaim subs(long subs) {
            this.subs = subs;
            return this;
        }

        public UserClaim data(long data) {
            this.data = data;
            return this;
        }

        public UserClaim payload(long payload) {
            this.payload = payload;
            return this;
        }

        public UserClaim bearerToken(boolean bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        public UserClaim allowedConnectionTypes(String ... allowedConnectionTypes) {
            this.allowedConnectionTypes = allowedConnectionTypes;
            return this;
        }
    }
}

