/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;

public abstract class Encoding {
    private static final String BASE32_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final int[] BASE32_LOOKUP = new int[256];
    private static final int MASK = 31;
    private static final int SHIFT = 5;

    private Encoding() {
    }

    @Deprecated
    public static byte[] base64Encode(byte[] input) {
        return Base64.getUrlEncoder().withoutPadding().encode(input);
    }

    public static byte[] base64UrlEncode(byte[] input) {
        return Base64.getUrlEncoder().withoutPadding().encode(input);
    }

    public static String toBase64Url(byte[] input) {
        return new String(Encoding.base64UrlEncode(input));
    }

    public static String toBase64Url(String input) {
        return new String(Encoding.base64UrlEncode(input.getBytes(StandardCharsets.US_ASCII)));
    }

    public static byte[] base64UrlDecode(byte[] input) {
        return Base64.getUrlDecoder().decode(input);
    }

    public static String fromBase64Url(String input) {
        return new String(Encoding.base64UrlDecode(input.getBytes(StandardCharsets.US_ASCII)));
    }

    public static char[] base32Encode(byte[] input) {
        int nonBlank;
        int last = input.length;
        char[] charBuff = new char[(last + 7) * 8 / 5];
        int offset = 0;
        int buffer = input[offset++];
        int bitsLeft = 8;
        int i = 0;
        while (bitsLeft > 0 || offset < last) {
            if (bitsLeft < 5) {
                if (offset < last) {
                    buffer <<= 8;
                    buffer |= input[offset++] & 0xFF;
                    bitsLeft += 8;
                } else {
                    int pad = 5 - bitsLeft;
                    buffer <<= pad;
                    bitsLeft += pad;
                }
            }
            int index = 0x1F & buffer >> bitsLeft - 5;
            bitsLeft -= 5;
            charBuff[i] = BASE32_CHARS.charAt(index);
            ++i;
        }
        for (nonBlank = charBuff.length - 1; nonBlank >= 0 && charBuff[nonBlank] == '\u0000'; --nonBlank) {
        }
        char[] retVal = new char[nonBlank + 1];
        System.arraycopy(charBuff, 0, retVal, 0, retVal.length);
        Arrays.fill(charBuff, '\u0000');
        return retVal;
    }

    public static byte[] base32Decode(char[] input) {
        byte[] bytes = new byte[input.length * 5 / 8];
        int buffer = 0;
        int next = 0;
        int bitsLeft = 0;
        for (int i = 0; i < input.length; ++i) {
            int lookup = input[i] - 48;
            if (lookup < 0 || lookup >= BASE32_LOOKUP.length) continue;
            int c = BASE32_LOOKUP[lookup];
            buffer <<= 5;
            buffer |= c & 0x1F;
            if ((bitsLeft += 5) < 8) continue;
            bytes[next++] = (byte)(buffer >> bitsLeft - 8);
            bitsLeft -= 8;
        }
        return bytes;
    }

    public static String jsonDecode(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        block9: for (int x = 0; x < len; ++x) {
            int ch = s.charAt(x);
            if (ch == 92) {
                int nextChar = x == len - 1 ? 92 : (int)s.charAt(x + 1);
                switch (nextChar) {
                    case 92: {
                        ch = 92;
                        break;
                    }
                    case 98: {
                        ch = 8;
                        break;
                    }
                    case 102: {
                        ch = 12;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 114: {
                        ch = 13;
                        break;
                    }
                    case 116: {
                        ch = 9;
                        break;
                    }
                    case 117: {
                        if (x >= len - 5) {
                            ch = 117;
                            break;
                        }
                        int code = Integer.parseInt("" + s.charAt(x + 2) + s.charAt(x + 3) + s.charAt(x + 4) + s.charAt(x + 5), 16);
                        sb.append(Character.toChars(code));
                        x += 5;
                        continue block9;
                    }
                    default: {
                        ch = nextChar;
                    }
                }
                ++x;
            }
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public static String jsonEncode(String s) {
        return Encoding.jsonEncode(new StringBuilder(), s).toString();
    }

    public static StringBuilder jsonEncode(StringBuilder sb, String s) {
        int len = s.length();
        block10: for (int x = 0; x < len; ++x) {
            char ch = s.charAt(x);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch < ' ') {
                        sb.append(String.format("\\u%04x", ch));
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb;
    }

    public static String uriDecode(String source) {
        try {
            return URLDecoder.decode(source.replace("+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return source;
        }
    }

    static {
        Arrays.fill(BASE32_LOOKUP, 255);
        int i = 0;
        while (i < BASE32_CHARS.length()) {
            int index = BASE32_CHARS.charAt(i) - 48;
            Encoding.BASE32_LOOKUP[index] = i++;
        }
    }
}

