/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.FetchConsumeOptions;
import io.nats.client.FetchConsumer;
import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamStatusCheckedException;
import io.nats.client.JetStreamStatusException;
import io.nats.client.Message;
import io.nats.client.PullRequestOptions;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.impl.NatsMessageConsumerBase;
import io.nats.client.impl.PullManagerObserver;
import io.nats.client.impl.SimplifiedSubscriptionMaker;
import java.io.IOException;

class NatsFetchConsumer
extends NatsMessageConsumerBase
implements FetchConsumer,
PullManagerObserver {
    private final long maxWaitNanos;
    private final String pullSubject;
    private long startNanos;

    NatsFetchConsumer(SimplifiedSubscriptionMaker subscriptionMaker, ConsumerInfo cachedConsumerInfo, FetchConsumeOptions fetchConsumeOptions) throws IOException, JetStreamApiException {
        super(cachedConsumerInfo);
        long expiresInMillis = fetchConsumeOptions.getExpiresInMillis();
        this.maxWaitNanos = expiresInMillis * 1000000L;
        long inactiveThreshold = expiresInMillis * 110L / 100L;
        PullRequestOptions pro = PullRequestOptions.builder(fetchConsumeOptions.getMaxMessages()).maxBytes(fetchConsumeOptions.getMaxBytes()).expiresIn(fetchConsumeOptions.getExpiresInMillis()).idleHeartbeat(fetchConsumeOptions.getIdleHeartbeat()).build();
        this.initSub(subscriptionMaker.subscribe(null, null, null, inactiveThreshold));
        this.pullSubject = this.sub._pull(pro, false, this);
        this.startNanos = -1L;
    }

    @Override
    public void pendingUpdated() {
    }

    @Override
    public void heartbeatError() {
        this.stopped.set(true);
        this.finished.set(true);
    }

    @Override
    public Message nextMessage() throws InterruptedException, JetStreamStatusCheckedException {
        try {
            long timeLeftMillis;
            if (this.finished.get()) {
                return null;
            }
            if (this.pmm.noMorePending()) {
                Message m = this.sub._nextUnmanagedNoWait(this.pullSubject);
                if (m == null) {
                    this.finished.set(true);
                    this.lenientClose();
                }
                return m;
            }
            if (this.startNanos == -1L) {
                this.startNanos = System.nanoTime();
            }
            if ((timeLeftMillis = (this.maxWaitNanos - (System.nanoTime() - this.startNanos)) / 1000000L) < 1L) {
                return this.sub._nextUnmanagedNoWait(this.pullSubject);
            }
            return this.sub._nextUnmanaged(timeLeftMillis, this.pullSubject);
        }
        catch (JetStreamStatusException e) {
            throw new JetStreamStatusCheckedException(e);
        }
        catch (IllegalStateException i) {
            return null;
        }
    }
}

