/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.Message;
import io.nats.client.SubscribeOptions;
import io.nats.client.api.ConsumerConfiguration;
import io.nats.client.api.DeliverPolicy;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.PushMessageManager;

class OrderedManager
extends PushMessageManager {
    private long expectedConsumerSeq = 1L;

    OrderedManager(NatsConnection conn, NatsJetStream js, String stream, SubscribeOptions so, ConsumerConfiguration serverCC, boolean queueMode, NatsDispatcher dispatcher) {
        super(conn, js, stream, so, serverCC, queueMode, dispatcher);
    }

    @Override
    protected boolean subManage(Message msg) {
        long receivedConsumerSeq = msg.metaData().consumerSequence();
        if (this.expectedConsumerSeq != receivedConsumerSeq) {
            this.handleErrorCondition();
            return true;
        }
        ++this.expectedConsumerSeq;
        return false;
    }

    @Override
    protected void handleHeartbeatError() {
        this.handleErrorCondition();
    }

    private void handleErrorCondition() {
        block2: {
            try {
                this.expectedConsumerSeq = 1L;
                this.sub.manager.shutdown();
                String newDeliverSubject = this.sub.connection.createInbox();
                this.sub.reSubscribe(newDeliverSubject);
                ConsumerConfiguration userCC = ConsumerConfiguration.builder(this.serverCC).deliverPolicy(DeliverPolicy.ByStartSequence).deliverSubject(newDeliverSubject).startSequence(Math.max(1L, this.lastStreamSeq + 1L)).startTime(null).build();
                this.js._createConsumerUnsubscribeOnException(this.stream, userCC, this.sub);
                this.sub.manager.startup(this.sub);
            }
            catch (Exception e) {
                IllegalStateException ise = new IllegalStateException("Ordered subscription fatal error.", e);
                this.js.conn.processException(ise);
                if (this.dispatcher != null) break block2;
                throw ise;
            }
        }
    }
}

