/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.service.EndpointResponse;
import io.nats.service.ServiceResponse;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;

public class StatsResponse
extends ServiceResponse {
    public static final String TYPE = "io.nats.micro.v1.stats_response";
    private final ZonedDateTime started;
    private final List<EndpointResponse> endpointStats;

    public StatsResponse(ServiceResponse template, ZonedDateTime started, List<EndpointResponse> endpointStats) {
        super(TYPE, template);
        this.started = started;
        this.endpointStats = endpointStats;
    }

    public StatsResponse(byte[] jsonBytes) {
        this(StatsResponse.parseMessage(jsonBytes));
    }

    private StatsResponse(JsonValue jv) {
        super(TYPE, jv);
        this.endpointStats = EndpointResponse.listOf(JsonValueUtils.readValue(jv, "endpoints"));
        this.started = JsonValueUtils.readDate(jv, "started");
    }

    @Override
    protected void subToJson(StringBuilder sb) {
        JsonUtils.addJsons(sb, "endpoints", this.endpointStats);
        JsonUtils.addField(sb, "started", this.started);
    }

    public ZonedDateTime getStarted() {
        return this.started;
    }

    public List<EndpointResponse> getEndpointStats() {
        return this.endpointStats;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatsResponse that = (StatsResponse)o;
        if (!Objects.equals(this.started, that.started)) {
            return false;
        }
        return Objects.equals(this.endpointStats, that.endpointStats);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.started != null ? this.started.hashCode() : 0);
        result = 31 * result + (this.endpointStats != null ? this.endpointStats.hashCode() : 0);
        return result;
    }
}

