/*
 * Decompiled with CFR 0.152.
 */
package io.nats.service;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.JsonValue;
import io.nats.client.support.JsonValueUtils;
import io.nats.client.support.Validator;
import java.util.Map;
import java.util.Objects;

public class Endpoint
implements JsonSerializable {
    private final String name;
    private final String subject;
    private final Map<String, String> metadata;

    public Endpoint(String name) {
        this(name, null, null, true);
    }

    public Endpoint(String name, Map<String, String> metadata) {
        this(name, null, metadata, true);
    }

    public Endpoint(String name, String subject) {
        this(name, subject, null, true);
    }

    public Endpoint(String name, String subject, Map<String, String> metadata) {
        this(name, subject, metadata, true);
    }

    Endpoint(String name, String subject, Map<String, String> metadata, boolean validate) {
        if (validate) {
            this.name = Validator.validateIsRestrictedTerm(name, "Endpoint Name", true);
            this.subject = subject == null ? this.name : Validator.validateSubject(subject, "Endpoint Subject", false, false);
        } else {
            this.name = name;
            this.subject = subject;
        }
        this.metadata = metadata == null || metadata.size() == 0 ? null : metadata;
    }

    Endpoint(JsonValue vEndpoint) {
        this.name = JsonValueUtils.readString(vEndpoint, "name");
        this.subject = JsonValueUtils.readString(vEndpoint, "subject");
        this.metadata = JsonValueUtils.readStringStringMap(vEndpoint, "metadata");
    }

    Endpoint(Builder b) {
        this(b.name, b.subject, b.metadata, true);
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "name", this.name);
        JsonUtils.addField(sb, "subject", this.subject);
        JsonUtils.addField(sb, "metadata", this.metadata);
        return JsonUtils.endJson(sb).toString();
    }

    public String toString() {
        return JsonUtils.toKey(this.getClass()) + this.toJson();
    }

    public String getName() {
        return this.name;
    }

    public String getSubject() {
        return this.subject;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint that = (Endpoint)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.subject, that.subject)) {
            return false;
        }
        return JsonUtils.mapEquals(this.metadata, that.metadata);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.subject != null ? this.subject.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String name;
        private String subject;
        private Map<String, String> metadata;

        public Builder endpoint(Endpoint endpoint) {
            this.name = endpoint.getName();
            this.subject = endpoint.getSubject();
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Endpoint build() {
            return new Endpoint(this);
        }
    }
}

