/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import io.nats.client.support.BuilderBase;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class ByteArrayBuilder
extends BuilderBase {
    private ByteBuffer buffer;

    public ByteArrayBuilder(int initialSize, int allocationSizeSuggestion, Charset defaultCharset) {
        super(defaultCharset, allocationSizeSuggestion);
        this.buffer = ByteBuffer.allocate(ByteArrayBuilder.bufferAllocSize(initialSize, this.allocationSize));
    }

    public ByteArrayBuilder() {
        this(-1, 32, StandardCharsets.US_ASCII);
    }

    public ByteArrayBuilder(int initialSize) {
        this(initialSize, 32, StandardCharsets.US_ASCII);
    }

    public ByteArrayBuilder(Charset defaultCharset) {
        this(-1, -1, defaultCharset);
    }

    public ByteArrayBuilder(int initialSize, Charset defaultCharset) {
        this(initialSize, -1, defaultCharset);
    }

    public ByteArrayBuilder(byte[] bytes) {
        this(bytes, bytes.length);
    }

    public ByteArrayBuilder(byte[] bytes, int len) {
        super(StandardCharsets.US_ASCII, 32);
        this.buffer = ByteBuffer.allocate(ByteArrayBuilder.bufferAllocSize(len, this.allocationSize));
        this.buffer.put(bytes, 0, bytes.length);
    }

    @Override
    public int length() {
        return this.buffer.position();
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public boolean equals(byte[] bytes) {
        if (bytes == null || this.buffer.position() != bytes.length) {
            return false;
        }
        byte[] hb = this.buffer.array();
        for (int x = 0; x < bytes.length; ++x) {
            if (hb[x] == bytes[x]) continue;
            return false;
        }
        return true;
    }

    public int copyTo(byte[] dest, int destPos) {
        int len = this.length();
        byte[] hb = this.buffer.array();
        System.arraycopy(hb, 0, dest, destPos, len);
        return len;
    }

    public void copyTo(OutputStream out) throws IOException {
        out.write(this.buffer.array(), 0, this.buffer.position());
    }

    @Override
    public byte[] toByteArray() {
        return Arrays.copyOf(this.buffer.array(), this.buffer.position());
    }

    @Override
    public byte[] internalArray() {
        return this.buffer.array();
    }

    public ByteArrayBuilder ensureCapacity(int bytesNeeded) {
        int bytesAvailable = this.buffer.capacity() - this.buffer.position();
        if (bytesAvailable < bytesNeeded) {
            ByteBuffer newBuffer = ByteBuffer.allocate(ByteArrayBuilder.bufferAllocSize(this.buffer.position() + bytesNeeded, this.allocationSize));
            newBuffer.put(this.buffer.array(), 0, this.buffer.position());
            this.buffer = newBuffer;
        }
        return this;
    }

    public ByteArrayBuilder clear() {
        this.buffer.clear();
        return this;
    }

    public ByteArrayBuilder setAllocationSize(int allocationSizeSuggestion) {
        this._setAllocationSize(allocationSizeSuggestion);
        return this;
    }

    public ByteArrayBuilder append(int i) {
        this.append(Integer.toString(i).getBytes(StandardCharsets.US_ASCII));
        return this;
    }

    public ByteArrayBuilder append(String src) {
        return this.append(src, this.defaultCharset);
    }

    public ByteArrayBuilder append(String src, Charset charset) {
        return src == null ? this.append(NULL, 0, 4) : this.append(src.getBytes(charset));
    }

    public ByteArrayBuilder append(CharBuffer src) {
        return this.append(src, this.defaultCharset);
    }

    public ByteArrayBuilder append(CharBuffer src, Charset charset) {
        if (src == null) {
            this.append(NULL, 0, 4);
        } else {
            this.append(src.toString().getBytes(charset));
        }
        return this;
    }

    public ByteArrayBuilder append(byte b) {
        this.ensureCapacity(1);
        this.buffer.put(b);
        return this;
    }

    public ByteArrayBuilder append(byte[] src) {
        if (src.length > 0) {
            this.ensureCapacity(src.length);
            this.buffer.put(src, 0, src.length);
        }
        return this;
    }

    public ByteArrayBuilder append(byte[] src, int len) {
        if (len > 0) {
            this.ensureCapacity(len);
            this.buffer.put(src, 0, len);
        }
        return this;
    }

    public ByteArrayBuilder append(byte[] src, int offset, int len) {
        if (len > 0) {
            this.ensureCapacity(len);
            this.buffer.put(src, offset, len);
        }
        return this;
    }

    public ByteArrayBuilder append(ByteArrayBuilder bab) {
        if (bab != null && bab.length() > 0) {
            this.append(bab.buffer.array(), 0, bab.length());
        }
        return this;
    }

    @Override
    public int appendUnchecked(byte b) {
        this.buffer.put(b);
        return 1;
    }

    @Override
    public int appendUnchecked(byte[] src) {
        this.buffer.put(src, 0, src.length);
        return src.length;
    }

    @Override
    public int appendUnchecked(byte[] src, int srcPos, int len) {
        this.buffer.put(src, srcPos, len);
        return len;
    }

    public String toString() {
        return new String(this.buffer.array(), 0, this.buffer.position(), this.defaultCharset);
    }
}

