/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import java.time.Duration;

public class PullRequestOptions
implements JsonSerializable {
    private final int batchSize;
    private final long maxBytes;
    private final boolean noWait;
    private final Duration expiresIn;
    private final Duration idleHeartbeat;

    public PullRequestOptions(Builder b) {
        this.batchSize = b.batchSize;
        this.maxBytes = b.maxBytes;
        this.noWait = b.noWait;
        this.expiresIn = b.expiresIn;
        this.idleHeartbeat = b.idleHeartbeat;
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "batch", this.batchSize);
        JsonUtils.addField(sb, "max_bytes", this.maxBytes);
        JsonUtils.addFldWhenTrue(sb, "no_wait", this.noWait);
        JsonUtils.addFieldAsNanos(sb, "expires", this.expiresIn);
        JsonUtils.addFieldAsNanos(sb, "idle_heartbeat", this.idleHeartbeat);
        return JsonUtils.endJson(sb).toString();
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getMaxBytes() {
        return this.maxBytes;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public Duration getExpiresIn() {
        return this.expiresIn;
    }

    public Duration getIdleHeartbeat() {
        return this.idleHeartbeat;
    }

    public static Builder builder(int batchSize) {
        return new Builder().batchSize(batchSize);
    }

    public static Builder noWait(int batchSize) {
        return new Builder().batchSize(batchSize).noWait();
    }

    public static class Builder {
        private int batchSize;
        private long maxBytes;
        private boolean noWait;
        private Duration expiresIn;
        private Duration idleHeartbeat;

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder maxBytes(long maxBytes) {
            this.maxBytes = maxBytes;
            return this;
        }

        public Builder noWait() {
            this.noWait = true;
            return this;
        }

        public Builder noWait(boolean noWait) {
            this.noWait = noWait;
            return this;
        }

        public Builder expiresIn(long expiresInMillis) {
            this.expiresIn = Duration.ofMillis(expiresInMillis);
            return this;
        }

        public Builder expiresIn(Duration expiresIn) {
            this.expiresIn = expiresIn;
            return this;
        }

        public Builder idleHeartbeat(long idleHeartbeatMillis) {
            this.idleHeartbeat = Duration.ofMillis(idleHeartbeatMillis);
            return this;
        }

        public Builder idleHeartbeat(Duration idleHeartbeat) {
            this.idleHeartbeat = idleHeartbeat;
            return this;
        }

        public PullRequestOptions build() {
            Validator.validateGtZero(this.batchSize, "Pull batch size");
            return new PullRequestOptions(this);
        }
    }
}

